package dev.bliss.impl.ui.mainmenu;

import dev.bliss.BloomReborn;
import dev.bliss.api.util.client.ClientUtil;
import dev.bliss.api.util.render.Render2D;
import dev.bliss.api.util.render.RoundUtil;
import dev.bliss.api.util.render.shader.GLShader;
import dev.bliss.impl.ui.altmanager.AltManager;
import dev.bliss.impl.ui.font.Fonts;
import dev.bliss.impl.ui.font.MCFontRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.*;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

import java.awt.*;
import java.io.IOException;
import java.util.Random;

import static dev.bliss.impl.ui.UiUtil.getArrayDynamic;

public class MainMenuGui extends GuiScreen {

    protected final MCFontRenderer font = new MCFontRenderer(Fonts.fontFromTTF(new ResourceLocation("bloom/fonts/roboto.ttf"), 18.0f, 0), true, true);
    protected final MCFontRenderer font2 = new MCFontRenderer(Fonts.fontFromTTF(new ResourceLocation("bloom/fonts/roboto.ttf"), 14.0f, 0), true, true);
    protected final MCFontRenderer gc = new MCFontRenderer(Fonts.fontFromTTF(new ResourceLocation("bloom/fonts/greycliff-bold.ttf"), 24.0f*2, 0), true, true);

    private GLShader shader;
    private long initTime = System.currentTimeMillis();
    String[] buttons = {"singleplayer", "multiplayer", "alt manager", "settings", "exit"};

    @Override
    public void initGui() {
        try {
            this.shader = new GLShader("/assets/minecraft/bloom/shader/background_shader.fsh");
        } catch (Exception e) {
            e.printStackTrace();
        }
        initTime = System.currentTimeMillis();
    }

    private boolean isHovered = false;
    private long t;
    private float currentalpha = 0;
    private float targetalpha = 0;

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks)
    {
        t = Minecraft.getSystemTime();
        ScaledResolution sr = new ScaledResolution(mc);
        GlStateManager.disableCull();
        this.shader.useShader(this.width, this.height, mouseX, mouseY, (System.currentTimeMillis() - initTime) / 250f);
        GL11.glBegin(GL11.GL_QUADS);
        GL11.glVertex2f(-1, -1);
        GL11.glVertex2f(-1, 1);
        GL11.glVertex2f(1, 1);
        GL11.glVertex2f(1, -1);
        GL11.glEnd();
        GL20.glUseProgram(0);
        GL11.glPushMatrix();

        float midx = sr.getScaledWidth() / 2;
        float midy = sr.getScaledHeight() / 2;
        Random random = new Random();
        int chance = random.nextInt(100);

        if (chance == 0) {
            gc.drawCenteredStringWithShadow("Gato", midx, midy - 100, getArrayDynamic(t, 255));
        } else {
            gc.drawCenteredStringWithShadow("Bloom", midx, midy - 100, getArrayDynamic(t, 255));
        }
        double buttonWidth = 100,buttonHeight = 20;
        double totalHeight = buttonHeight * buttons.length;

        float startX = (float) (sr.getScaledWidth() / 2 - buttonWidth / 2);
        float endX = (float) (sr.getScaledWidth() / 2 + buttonWidth / 2);
        float y = (float) (sr.getScaledHeight() / 2 - totalHeight * 0.3);

        targetalpha = isHovered ? 255 : 0;
        currentalpha = (float) Render2D.interpolate(currentalpha, targetalpha, 0.1f);

        // <-- button rendering
        RoundUtil.drawBorderedRoundedRect(startX - 5, y - 5, (float) (buttonWidth + 10), (float) (totalHeight + 30), 10, 2, getArrayDynamic(t, 255), new Color(10, 10, 10, 100).getRGB());
        for (String b : buttons)
        {
            //Render2D.drawBorderedRect(startX, y, (float) (buttonWidth), (float) (buttonHeight), 1, new Color(65, 44, 129).getRGB(), new Color(45, 8, 100, 35).getRGB());
            if (mouseX > startX && mouseX < startX + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                RoundUtil.drawBorderedRoundedRect(startX, y, (float) (buttonWidth), (float) (buttonHeight), 5, 1, getArrayDynamic(t, 255), new Color(0, 0, 0, 0).getRGB());
                isHovered = true;
            } else {
                isHovered = false;
            }
            font.drawCenteredStringWithShadow(b, startX + (buttonWidth / 2), y + (buttonHeight / 2) - 2.5f, getCol());
            y += buttonHeight + 5;
        }

        String c = "Bloom Reborn §f[§7" + BloomReborn.INSTANCE.getBuild() + "§f]";

        font.drawStringWithShadow(c, 10, 11, getArrayDynamic(t, 255));

        int offset = 10;
        for (String cl : ClientUtil.changeLog) {
            String prefix = getPrefix(cl);
            font2.drawStringWithShadow(prefix, 10, 10 + font2.getStringHeight(c) + offset, new Color(150, 150, 150, 255).getRGB());
            offset += 10;
        }
        GL11.glPopMatrix();
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            ScaledResolution sr = new ScaledResolution(mc);
            double buttonWidth = 110, buttonHeight = 20;
            double totalHeight = buttonHeight * buttons.length;

            double y = sr.getScaledHeight() / 2 - totalHeight * 0.3;
            double startX = sr.getScaledWidth() / 2 - buttonWidth / 2;
            double endX = sr.getScaledWidth() / 2 + buttonWidth / 2;
            for (String b : buttons) {
                if (mouseX > startX && mouseX < startX + buttonWidth && mouseY > y && mouseY < y + buttonHeight) {
                    switch (b) {
                        case "singleplayer":
                            mc.displayGuiScreen(new GuiSelectWorld(this));
                            break;
                        case "multiplayer":
                            mc.displayGuiScreen(new GuiMultiplayer(this));
                            break;
                        case "alt manager":
                            mc.displayGuiScreen(new AltManager(this));
                            break;
                        case "settings":
                            mc.displayGuiScreen(new GuiOptions(this, mc.gameSettings));
                            break;
                        case "exit":
                            mc.shutdown();
                            break;
                    }
                }
                y += buttonHeight + 5;
            }
        }
    }

    private static String getPrefix(String change) {
        String prefix = "";
        if (change.contains("[+]")) {
            change = change.replace("[+] ", "");
            prefix = EnumChatFormatting.GREEN + "[+] " + EnumChatFormatting.RESET;
        } else if (change.contains("[-]")) {
            change = change.replace("[-] ", "");
            prefix = EnumChatFormatting.RED + "[-] " + EnumChatFormatting.RESET;
        } else if (change.contains("[~]")) {
            change = change.replace("[~] ", "");
            prefix = EnumChatFormatting.LIGHT_PURPLE + "[~] " + EnumChatFormatting.RESET;
        } else if (change.contains("[*]")) {
            change = change.replace("[*] ", "");
            prefix = EnumChatFormatting.GOLD + "[*] " + EnumChatFormatting.RESET;
        } else if (change.contains("[-]")) {
            change = change.replace("[-] ", "");
            prefix = EnumChatFormatting.RED + "[-] " + EnumChatFormatting.RESET;
        }

        return prefix + change;
    }

    public int getCol() {
        if (isHovered) {
            return getArrayDynamic(t, 255);
        } else return new Color(205, 200, 240).getRGB();
    }
}
