package dev.bliss.impl.ui.hud;

import dev.bliss.api.event.events.EventRender2D;
import dev.bliss.api.util.render.ColorUtil;
import dev.bliss.impl.module.Module;
import dev.bliss.impl.module.ModuleManager;
import dev.bliss.impl.module.impl.visual.HudMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

import java.awt.*;
import java.util.*;

import static dev.bliss.impl.ui.UiUtil.getArrayDynamic;

public class Arraylist extends HudMod
{
    Color bliss;
    Color raven;
    int astolfo;
    final ArrayList<Module> enabledMods = ModuleManager.getModules();
    final ArrayList<Module> mods = new ArrayList<>(enabledMods);

    private static final long ANIMATION_DURATION = 500;
    private long animationStartTime = -1;

    public static Arraylist INSTANCE = new Arraylist();
    private final Comparator<Object> SORT_METHOD = Comparator.comparingDouble(m -> {
        Module module = (Module) m;
        return font.isEnabled() ? Cfont.getStringWidth(module.getName() + " " + module.getSuffix()) : fr.getStringWidth(module.getName() + " " + module.getSuffix());
    }).reversed();

    // <-- Themes

    public void blissArray(EventRender2D e)
    {
        int counter = 1;
        float t = Minecraft.getSystemTime();
        float y = 0;
        float fontWidth = 0;
        mods.sort(SORT_METHOD);
        for (Module mod : mods) {
            boolean visible = mod.isVisible();
            float x = 0;
            float margin = 0;
            if (mod.isEnabled() && !Objects.equals(mod.getName(), "Hud")) {

                GL11.glPushMatrix();

                // <-- Font Height
                float fontHeight = Cfont.getHeight();
                // <-- Font Width
                fontWidth = mod.getSuffix().isEmpty() ? Cfont.getStringWidth(mod.getDisplayName()) : Cfont.getStringWidth(mod.getDisplayName()) + Cfont.getStringWidth(mod.getSuffix());
                // <-- Width
                float width = e.getWidth();
                // <-- Position for drawing font
                x = (width - fontWidth) - 4.0F;
                // <-- Position Y for drawing font
                y = counter * (Cfont.getStringHeight(mod.getDisplayName()) + 1.0F);
                // <-- Background color
                int bCol = new Color(0, 0, 0, (int) backgroundAlpha.getValue()).getRGB();
                // <-- Rect Indent
                margin = rect.enabled ? 2.5F : 1.5F;

                translate.animate(x - margin, y);
                mod.getTranslate().setX(x);

                double transX = translate.getX();
                double transY = translate.getY();

                // <-- Background
                Gui.drawRect(
                        (x + 4) - margin - 1,
                        y - (mods.indexOf(mod) == 0 ? 3 : 0),
                        width,
                        y + fontHeight + (mods.indexOf(mod) == mods.size() - 1 ? 2 : 1), bCol);

                if (!mod.getSuffix().isEmpty())
                    Cfont.drawStringWithShadow(mod.getDisplayName() + " §7" + mod.getSuffix(), x - margin - 3.0F, y - 2.0F, getArrayDynamic(t, 255));
                else
                    Cfont.drawStringWithShadow(mod.getDisplayName(), x - margin, y - 2.0F, getArrayDynamic(t, 255));
                GL11.glPopMatrix();
                t -= 300;
                counter++;
            } else
                mod.getTranslate().setX(e.getWidth());
            mod.getTranslate().setY(y);
        }
    }

    public void blissArrayB(EventRender2D e)
    {
        int counter = 1;
        float t = Minecraft.getSystemTime();
        float y = 0;
        mods.sort(SORT_METHOD);
        for (Module mod : mods) {
            if (mod.isEnabled() && !Objects.equals(mod.getName(), "hud"))
            {

                GL11.glPushMatrix();

                // <-- Font Height
                float fontHeight = fr.getStringHeight(mod.getDisplayName());
                // <-- Font Width
                float fontWidth = mod.getSuffix().isEmpty() ? fr.getStringWidth(mod.getDisplayName()) : fr.getStringWidth(mod.getDisplayName()) + fr.getStringWidth(mod.getSuffix());
                // <-- Width
                float width = e.getWidth();
                // <-- Position for drawing font
                float x = (width) - fontWidth - 4.0F;
                // <-- Position Y for drawing font
                y = counter * (fr.getStringHeight(mod.getDisplayName()) + 1.0F);
                // <-- Background color
                int bCol = new Color(0, 0, 0, (int) backgroundAlpha.getValue()).getRGB();
                // <-- Rect Indent
                float margin = rect.enabled ? 2.5F : 1.5F;

                // <-- Background
                Gui.drawRect(
                        (x + 4) - margin - 1,
                        y - (mods.indexOf(mod) == 0 ? 3 : 0),
                        width,
                        y + fontHeight + (mods.indexOf(mod) == mods.size() - 1 ? 2 : 1), bCol);

                if (!mod.getSuffix().isEmpty())
                    fr.drawStringWithShadow(mod.getDisplayName() + " §7" + mod.getSuffix(), x - margin - 3.0F, y - 5.0F, getArrayDynamic(t, 255));
                else
                    fr.drawStringWithShadow(mod.getDisplayName(), x - margin, y - 5.0F, getArrayDynamic(t, 255));
                GL11.glPopMatrix();
                t -= 300;
                counter++;
            }
        }
    }

    public void astolfoArray(EventRender2D e)
    {
        int counter = 1;
        float t = Minecraft.getSystemTime();
        float y = 0;
        mods.sort(SORT_METHOD);
        for (Module mod : mods) {
            if (mod.isEnabled() && !Objects.equals(mod.getName(), "Hud"))
            {

                GL11.glPushMatrix();

                // <-- Font Height
                float fontHeight = Cfont.getHeight();
                // <-- Font Width
                float fontWidth = mod.getSuffix().isEmpty() ? Cfont.getStringWidth(mod.getDisplayName()) : Cfont.getStringWidth(mod.getDisplayName()) + Cfont.getStringWidth(mod.getSuffix());
                // <-- Font color
                astolfo = ColorUtil.astolfo(counter * -100, 1.0F, 0.47F);
                // <-- Width
                float width = e.getWidth();
                // <-- Position for drawing font
                float x = (width) - fontWidth - 4.0F;
                // <-- Position Y for drawing font
                y = counter * (Cfont.getStringHeight(mod.getDisplayName()) + 1.0F);
                // <-- Background color
                int bCol = new Color(0, 0, 0, (int) backgroundAlpha.getValue()).getRGB();
                // <-- Rect Indent
                float margin = rect.enabled ? 2.5F : 1.5F;

                // <-- Background
                Gui.drawRect(
                        (x + 4) - margin - 1,
                        y - (mods.indexOf(mod) == 0 ? 3 : 0),
                        width,
                        y + fontHeight + (mods.indexOf(mod) == mods.size() - 1 ? 2 : 1), bCol);

                if (!mod.getSuffix().isEmpty())
                    Cfont.drawStringWithShadow(mod.getDisplayName() + " §7" + mod.getSuffix(), x - margin - 3.0F, y - 2.0F, astolfo);
                else
                    Cfont.drawStringWithShadow(mod.getDisplayName(), x - margin, y - 2.0F, astolfo);
                GL11.glPopMatrix();
                t -= 300;
                counter++;
            }
        }
    }

    public void astolfoArrayB(EventRender2D e)
    {
        int counter = 1;
        float t = Minecraft.getSystemTime();
        float y = 0;
        mods.sort(SORT_METHOD);
        for (Module mod : mods) {
            if (mod.isEnabled() && !Objects.equals(mod.getName(), "hud"))
            {

                GL11.glPushMatrix();

                // <-- Font Height
                float fontHeight = fr.getStringHeight(mod.getDisplayName()) + 5.0F;
                // <-- Font Width
                float fontWidth = mod.getSuffix().isEmpty() ? fr.getStringWidth(mod.getDisplayName()) : fr.getStringWidth(mod.getDisplayName()) + fr.getStringWidth(mod.getSuffix());
                // <-- Font color
                astolfo = ColorUtil.astolfo(counter * -100, 1.0F, 0.47F);
                // <-- Width
                float width = e.getWidth();
                // <-- Position for drawing font
                float x = (width) - fontWidth - 4.0F;
                // <-- Position Y for drawing font
                y = counter * (fr.getStringHeight(mod.getDisplayName()) + 1.0F);
                // <-- Background color
                int bCol = new Color(0, 0, 0, (int) backgroundAlpha.getValue()).getRGB();
                // <-- Rect Indent
                float margin = rect.enabled ? 2.5F : 1.5F;

                // <-- Background
                Gui.drawRect(
                        (x + 4) - margin - 1,
                        y - (mods.indexOf(mod) == 0 ? 3 : 0),
                        width,
                        y + fontHeight + (mods.indexOf(mod) == mods.size() - 1 ? 2 : 1), bCol);

                if (!mod.getSuffix().isEmpty())
                    fr.drawStringWithShadow(mod.getDisplayName() + " §7" + mod.getSuffix(), x - margin - 3.0F, y - 5.0F, astolfo);
                else
                    fr.drawStringWithShadow(mod.getDisplayName(), x - margin, y - 5.0F, astolfo);
                GL11.glPopMatrix();
                t -= 300;
                counter++;
            }
        }
    }

    // <-- extra stuff here

}
