package dev.bliss.impl.ui.font;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

import java.awt.*;

@Setter
@Getter
public class Fonts
{
    public static MCFontRenderer sf; // <-- this is product sands is gudd
    public static MCFontRenderer sfui;
    public static MCFontRenderer greycliff;
    public static MCFontRenderer greycliffbold;
    public static MCFontRenderer neverlose;
    public static MCFontRenderer icons;
    public static MCFontRenderer icons2;

    public static void startFonts() {
        Fonts.sf = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/sf.ttf"), 16.0f, 0), true, false);
        Fonts.sfui = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/sfui.ttf"), 16.0f, 0), true, false);
        Fonts.greycliff = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/greycliff.ttf"), 16.0f, 0), true, false);
        Fonts.greycliffbold = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/greycliff-bold.ttf"), 16.0f, 0), true, false);
        Fonts.neverlose = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/neverlose.ttf"), 16.0f, 0), true, false);
        Fonts.icons = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/icons.ttf"), 16.0f, 0), true, false);
        Fonts.icons2 = new MCFontRenderer(fontFromTTF(new ResourceLocation("bloom/fonts/icons2.ttf"), 16.0f, 0), true, false);
    }

    public static Font fontFromTTF(final ResourceLocation fontLocation, final float fontSize, final int fontType) {
        Font output = null;
        try {
            output = Font.createFont(fontType, Minecraft.getMinecraft().getResourceManager().getResource(fontLocation).getInputStream());
            output = output.deriveFont(fontSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }
}
