package dev.bliss.impl.ui;

import dev.bliss.BloomReborn;
import dev.bliss.impl.module.impl.visual.HudMod;
import net.minecraft.util.MathHelper;

import java.awt.*;

public class UiUtil extends HudMod
{

    public static int getArrayDynamic(float counter, int alpha) {
        Color main = BloomReborn.INSTANCE.mainColor;
        Color second = BloomReborn.INSTANCE.secondaryColor;

        float[] mainHSB = Color.RGBtoHSB(main.getRed(), main.getGreen(), main.getBlue(), null);
        float[] secondaryHSB = Color.RGBtoHSB(second.getRed(), second.getGreen(), second.getBlue(), null);

        // Interpolate between main and secondary colors based on the counter value
        float brightness = 1.0F - MathHelper.abs(MathHelper.sin((float) (counter % 6000F / 6000F * Math.PI * 2.0F)) * 0.6F);
        float[] hudHSB = new float[3];
        for (int i = 0; i < 3; i++) {
            hudHSB[i] = mainHSB[i] + (secondaryHSB[i] - mainHSB[i]) * brightness;
        }

        // Convert HSB to RGB color
        Color color = Color.getHSBColor(hudHSB[0], hudHSB[1], hudHSB[2]);

        // Return the RGB color with alpha
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha).getRGB();
    }

    public static int getRavenColor(float counter, int alpha) {
        Color main = new Color(255, 100, 129);
        Color second = new Color(244, 191, 200);

        float[] mainHSB = Color.RGBtoHSB(main.getRed(), main.getGreen(), main.getBlue(), null);
        float[] secondaryHSB = Color.RGBtoHSB(second.getRed(), second.getGreen(), second.getBlue(), null);

        // Interpolate between main and secondary colors based on the counter value
        float brightness = 1.0F - MathHelper.abs(MathHelper.sin((float) (counter % 6000F / 6000F * Math.PI * 2.0F)) * 0.6F);
        float[] hudHSB = new float[3];
        for (int i = 0; i < 3; i++) {
            hudHSB[i] = mainHSB[i] + (secondaryHSB[i] - mainHSB[i]) * brightness;
        }

        // Convert HSB to RGB color
        Color color = Color.getHSBColor(hudHSB[0], hudHSB[1], hudHSB[2]);

        // Return the RGB color with alpha
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha).getRGB();
    }

}
