package dev.bliss.impl.module.impl.visual;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.EventTarget;
import dev.bliss.api.event.events.EventRender2D;
import dev.bliss.api.setting.ModuleCategory;
import dev.bliss.api.setting.Setting;
import dev.bliss.api.setting.impl.*;
import dev.bliss.api.util.client.Priority;
import dev.bliss.impl.module.Category;
import dev.bliss.impl.module.Module;
import dev.bliss.impl.ui.font.Fonts;
import dev.bliss.impl.ui.font.MCFontRenderer;
import dev.bliss.impl.ui.hud.Arraylist;
import dev.bliss.impl.ui.hud.Watermark;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class HudMod extends Module {

    public Setting[] settings;
    public SettingMode themes;
    public SettingBool font;
    public ModuleCategory watermark;
    public SettingMode wmMode;
    public ModuleCategory arraylist;
    public SettingBool arraytoggle;
    public SettingDouble arrayalpha;
    public SettingDouble backgroundAlpha;
    public SettingBool rect;

    protected final FontRenderer fr = this.mc.fontRendererObj;
    protected final MCFontRenderer Cfont = new MCFontRenderer(Fonts.fontFromTTF(new ResourceLocation("bloom/fonts/roboto.ttf"), 18.0f, 0), true, true);
    protected final MCFontRenderer greycliff = new MCFontRenderer(Fonts.fontFromTTF(new ResourceLocation("bloom/fonts/greycliff.ttf"), 16.0f, 0), true, true);
    protected final MCFontRenderer greycliffB = new MCFontRenderer(Fonts.fontFromTTF(new ResourceLocation("bloom/fonts/greycliff-bold.ttf"), 16.0f*2, 0), true, true);
    protected final ScaledResolution sr = new ScaledResolution(this.mc);

    public HudMod() {
        super("Hud", Keyboard.KEY_NONE, Category.VISUAL, Priority.low);

        this.themes = new SettingMode("Theme", "Reborn", new String[] { "Reborn", "Astolfo", "Raven" });
        this.font = new SettingBool("CFont", true);
        this.watermark = new ModuleCategory("Watermark...");
        this.wmMode = new SettingMode("Mode", "Bliss", new String[] { "Bliss", "Old", "Exhibition", "None" });
        this.arraylist = new ModuleCategory("ArrayList...");
        this.arraytoggle = new SettingBool("Toggle ArrayList", true);
        this.arrayalpha = new SettingDouble("Arraylist Brightness", 255.0f, 0.0f, 255.0f, 1.0f);
        this.backgroundAlpha = new SettingDouble("Background Alpha", 0.0f, 0.0f, 255.0f, 1.0f);
        this.rect = new SettingBool("Rect", false);

        this.settings = new Setting[] { themes, watermark, arraylist, font };
        this.watermark.addCatSettings(wmMode);
        this.arraylist.addCatSettings(arraytoggle, backgroundAlpha, rect);
        this.addSettings(settings);
    }

    public float getHeight(Module mod) {
        float y = 2;
        for (Module module : BloomReborn.INSTANCE.moduleManager.getModules()) {
            if (module == mod) {
                return y;
            }
            if (font.enabled) {
                y += Cfont.getHeight();
            } else {
                y += mc.fontRendererObj.getHeight();
            }
        }

        return 2;
    }

    @EventTarget
    public void onRender2d(final EventRender2D e) {
        this.setSuffix(themes.getMode());

        if (!this.mc.gameSettings.showDebugInfo) {
            final float h = e.getHeight();
            final float w = e.getWidth();
            switch (wmMode.getMode()) {
                case "Old":
                    if (font.enabled) Watermark.INSTANCE.Old(e);
                    else Watermark.INSTANCE.OldB(e);
                    break;
                case "Bliss":
                    if (font.enabled) Watermark.INSTANCE.Bliss(e);
                    else Watermark.INSTANCE.BlissB(e);
                    break;
                case "Exhibition":
                    Watermark.INSTANCE.Exhibition(e);
                    break;
                case "default":
                    break;
            }

            if (arraytoggle.enabled) {
                switch (themes.getMode()) {
                    case "Reborn":
                        if (font.enabled)
                            Arraylist.INSTANCE.blissArray(e);
                        else
                            Arraylist.INSTANCE.blissArrayB(e);
                        break;
                    case "Astolfo":
                        if (font.enabled)
                            Arraylist.INSTANCE.astolfoArray(e);
                        else
                            Arraylist.INSTANCE.astolfoArrayB(e);
                        break;
                    case "Raven":
                    case "default":
                        break;
                }
            }
        }
    }

}
