package dev.bliss.impl.module.impl.visual;

import dev.bliss.api.event.EventTarget;
import dev.bliss.api.event.events.EventRender3D;
import dev.bliss.api.util.client.Priority;
import dev.bliss.api.util.render.EspUtil;
import dev.bliss.impl.module.Category;
import dev.bliss.impl.module.Module;
import dev.bliss.impl.module.impl.Targets;
import dev.bliss.impl.module.impl.combat.KillAuraMod;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class EspMod extends Module {

    public EspMod() {
        super("Esp", Keyboard.KEY_NONE, Category.VISUAL, Priority.med);
    }

    @EventTarget
    public void onRender(EventRender3D e) {
        for (EntityPlayer player : mc.theWorld.playerEntities) {
            if (!player.isEntityAlive() || player == mc.thePlayer || !KillAuraMod.isBot(player) || player.isInvisible()) continue;
            double x = EspUtil.interp(player.posX, player.lastTickPosX) - mc.getRenderManager().renderPosX;
            double y = EspUtil.interp(player.posY, player.lastTickPosY) - mc.getRenderManager().renderPosY;
            double z = EspUtil.interp(player.posZ, player.lastTickPosZ) - mc.getRenderManager().renderPosZ;
            GlStateManager.pushMatrix();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glDisable((int)2929);
            float distance = MathHelper.clamp_float(mc.thePlayer.getDistanceToEntity(player), 20.0f, Float.MAX_VALUE);
            double scale = 0.005 * (double)distance;
            GlStateManager.translate(x, y, z);
            GlStateManager.rotate(-mc.getRenderManager().playerViewY, 0.0f, 1.0f, 0.0f);
            GlStateManager.scale(-0.1, -0.1, 0.0);
            EspUtil.entityESPBox(player, 0);
        }
    }
}
