package dev.bliss.impl.module.impl.player;

import dev.bliss.api.event.EventTarget;
import dev.bliss.api.event.events.EventMotion;
import dev.bliss.api.event.events.EventReceivePacket;
import dev.bliss.api.event.events.EventTick;
import dev.bliss.api.setting.impl.SettingBool;
import dev.bliss.api.setting.impl.SettingDouble;
import dev.bliss.api.util.client.Priority;
import dev.bliss.api.util.client.TimerUtil;
import dev.bliss.impl.module.Category;
import dev.bliss.impl.module.Module;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockTNT;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.*;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import org.apache.commons.lang3.time.StopWatch;
import org.lwjgl.input.Keyboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class StealerMod extends Module {

    private String[] list = new String[]{"mode", "delivery", "menu", "selector", "game", "gui", "server", "inventory", "play", "teleporter",
            "shop", "melee", "armor", "block", "castle", "mini", "warp", "teleport", "user", "team", "tool", "sure", "trade", "cancel", "accept",
            "soul", "book", "recipe", "profile", "tele", "port", "map", "kit", "select", "lobby", "vault", "lock", "anticheat", "travel", "settings",
            "user", "preference", "compass", "cake", "wars", "buy", "upgrade", "ranged", "potions", "utility"};

    public SettingBool rand;
    public SettingBool aclose;
    public SettingBool extrapacket;
    public SettingDouble min;
    public SettingDouble max;

    private double time;
    public boolean isStealing;
    public int containerSize,windowID;
    TimerUtil timer = new TimerUtil();
    StopWatch stopwatch = new StopWatch();
    public ItemStack stack;

    ArrayList<Integer> items = new ArrayList<>();

    public StealerMod() {
        super("Stealer", Keyboard.KEY_NONE, Category.PLAYER, Priority.high);

        rand = new SettingBool("Random", false);
        aclose = new SettingBool("Auto Close", true);
        extrapacket = new SettingBool("Extra Packet", true);
        min = new SettingDouble("Min Speed", 50, 0, 500, 5);
        max = new SettingDouble("Max Speed", 100, 0, 500, 5);
        this.addSettings(rand, aclose, extrapacket, min, max);
    }

    @EventTarget
    public void onMotion(EventMotion e) {
        // Check if event is pre and player has a chest open
        if (e.isPre() && mc.thePlayer.openContainer instanceof ContainerChest) {
            ContainerChest container = (ContainerChest) mc.thePlayer.openContainer;
            IInventory lcInventory = container.getLowerChestInventory();

            // Check if "Chest" is actually open
            if (Objects.equals(lcInventory.getName(), "Chest")) {
                isStealing = true;
                steal(container, lcInventory); // Attempt to steal items from the chest
            }
        }
    }

    @EventTarget
    public void onPacket(EventReceivePacket e) {
        if (e.getPacket() instanceof S2DPacketOpenWindow) {
            S2DPacketOpenWindow packet = (S2DPacketOpenWindow) e.getPacket();
            for (String blacklist : list) {
                if (packet.getWindowTitle().getUnformattedText().toLowerCase().contains(blacklist)) {
                    isStealing = false;
                    return;
                }
            }

            isStealing = packet.getGuiId().equals("minecraft:chest");

            if (isStealing) {
                containerSize = packet.getSlotCount();
                windowID = packet.getWindowId();
            }
        }
    }

    @EventTarget
    public void onTick(EventTick e) {
        if (isStealing) {
            if (!items.isEmpty()) {
                Collections.reverse(items);
                for (int i = 0; i < items.size(); i++) {
                    if (extrapacket.isEnabled() || timer.delay(delay)) {
                        mc.playerController.windowClick(windowID, items.get(i), 0, 1, mc.thePlayer);
                        items.remove(items.get(i));
                        timer.reset();
                    }
                }
            }else{
                mc.thePlayer.closeScreen();
                isStealing = false;
            }
        }
    }

    // Generate a random float value between two given values
    public float nextFloat(final float startInclusive, final float endInclusive) {
        if (startInclusive == endInclusive || endInclusive - startInclusive <= 0F)
            return startInclusive;

        return (float) (startInclusive + ((endInclusive - startInclusive) * Math.random()));
    }

    // Generate a random integer value between two given values
    public int nextInt(final int startInclusive, final int endInclusive) {
        if (startInclusive == endInclusive || endInclusive - startInclusive <= 0F)
            return startInclusive;

        return (int) (startInclusive + ((endInclusive - startInclusive) * Math.random()));
    }

    private boolean itemWhitelisted(final ItemStack itemStack)
    {
        final ArrayList<Item> whitelistedItems = new ArrayList<Item>()
        {
            {
                add(Items.ender_pearl);
                add(Items.iron_ingot);
                add(Items.snowball);
                add(Items.gold_ingot);
                add(Items.redstone);
                add(Items.diamond);
                add(Items.emerald);
                add(Items.quartz);
                add(Items.bow);
                add(Items.arrow);
                add(Items.fishing_rod);
            }
        };
        final Item item = itemStack.getItem();
        final String itemName = itemStack.getDisplayName();

        if (itemName.contains("Right Click") || itemName.contains("Click to Use") || itemName.contains("Players Finder"))
        {
            return true;
        }

        final ArrayList<Integer> whitelistedPotions = new ArrayList<Integer>()
        {
            {
                add(6);
                add(1);
                add(5);
                add(8);
                add(14);
                add(12);
                add(10);
                add(16);
            }
        };

        if (item instanceof ItemPotion)
        {
            final int potionID = getPotionId(itemStack);
            return whitelistedPotions.contains(potionID);
        }

        return (item instanceof ItemBlock
                && !(((ItemBlock) item).getBlock() instanceof BlockTNT)
                && !(((ItemBlock) item).getBlock() instanceof BlockSlime)
                && !(((ItemBlock) item).getBlock() instanceof BlockFalling))
                || item instanceof ItemAnvilBlock
                || item instanceof ItemSword
                || item instanceof ItemArmor
                || item instanceof ItemTool
                || item instanceof ItemFood
                || item instanceof ItemSkull
                || itemName.contains("\247")
                || whitelistedItems.contains(item)
                && !item.equals(Items.spider_eye);
    }

    private int getPotionId(final ItemStack potion)
    {
        final Item item = potion.getItem();

        try
        {
            if (item instanceof ItemPotion)
            {
                final ItemPotion p = (ItemPotion) item;
                return p.getEffects(potion.getMetadata()).get(0).getPotionID();
            }
        }
        catch (final NullPointerException ignored)
        {
        }

        return 0;
    }

    // Steal items from the chest with a randomized delay
    public int delay;
    public void steal(ContainerChest container, IInventory lowerChestInventory) {
        if (mc.thePlayer.openContainer != null && mc.thePlayer.openContainer instanceof ContainerChest) {
            if (container.getLowerChestInventory().getName().equalsIgnoreCase("chest")) {

                if (rand.isEnabled()) {
                    for (int i = 0; i < lowerChestInventory.getSizeInventory(); i++) {
                        items.add(i);
                    }
                    Collections.shuffle(items);
                } else {
                    for (int i = 0; i < lowerChestInventory.getSizeInventory(); i++) {
                        items.add(i);
                    }
                }

                boolean stolen = false;
                Collections.reverse(items);
                for (int index : items) {
                    stack = lowerChestInventory.getStackInSlot(index);
                    if (lowerChestInventory.getStackInSlot(index) != null && itemWhitelisted(stack)) {
                        if (this.stopwatch.getNanoTime() >= delay) {
                            isStealing = true;
                            delay = nextInt((int) min.getValue(), (int) max.getValue()) * 1000000;
                            if (extrapacket.isEnabled()) return;
                            mc.playerController.windowClick(container.windowId, index, 0, 1, mc.thePlayer);
                            stopwatch.reset();
                            stopwatch.start();
                        }
                    }else if (items.isEmpty()) {
                        mc.thePlayer.closeScreen();
                        isStealing = false;
                        stolen = true;
                    }
                }
            }
        }
    }
}
