package dev.bliss.impl.module.impl.player;

import dev.bliss.api.event.EventTarget;
import dev.bliss.api.event.events.EventMotion;
import dev.bliss.api.event.events.EventReceivePacket;
import dev.bliss.api.event.events.EventSendPacket;
import dev.bliss.api.event.events.EventUpdate;
import dev.bliss.api.setting.impl.SettingMode;
import dev.bliss.api.util.client.Priority;
import dev.bliss.api.util.math.MathUtil;
import dev.bliss.api.util.player.MoveUtil;
import dev.bliss.api.util.player.RotationUtil;
import dev.bliss.impl.module.Category;
import dev.bliss.impl.module.Module;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.C03PacketPlayer;
import net.minecraft.network.play.client.C0BPacketEntityAction;
import net.minecraft.network.play.server.S08PacketPlayerPosLook;
import net.minecraft.potion.Potion;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.input.Keyboard;

public class ScaffoldMod extends Module {

    SettingMode sprintMode, towerMode, rotMode;
    BlockData blockData, lastBlockData;
    private float teleportYaw, teleportPitch;
    private boolean teleported;

    public ScaffoldMod() {
        super("Scaffold", Keyboard.KEY_NONE, Category.PLAYER, Priority.high);
        sprintMode = new SettingMode("Sprint Mode", "Always", "Always", "Never", "Verus", "Watchdog");
        towerMode = new SettingMode("Tower Mode", "Vanilla", "Vanilla", "Verus", "Watchdog");
        rotMode = new SettingMode("Sprint Mode", "Backwards", "Backwards", "0 0", "Enum", "Side");
        addSettings(sprintMode, towerMode, rotMode);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        blockData = null;
        lastBlockData = null;
    }

    @EventTarget
    public void onMotion(EventMotion e) {
        setSuffix(rotMode.getMode());
        BlockPos blockPos = new BlockPos(mc.thePlayer.posX, mc.thePlayer.posY - 1, mc.thePlayer.posZ);
        if (mc.theWorld.getBlockState(blockPos).getBlock() == Blocks.air) {
            blockData = getBlockPos();
            if (blockData != null) {
                lastBlockData = getBlockPos();
            } else {
                return;
            }
        }
        if (e.isPre()) {
            switch (rotMode.getMode().toLowerCase()) {
                case "backwards":
                    e.setYaw(MoveUtil.getPlrDir(mc.thePlayer.rotationYaw + 180));
                    e.setPitch(MathUtil.randomFloat(83.5f, 77.5f));
                    break;
                case "0 0":
                    e.setYaw(0);
                    e.setPitch(0);
                    break;
                case "enum":
                    if (lastBlockData != null) {
                        e.setYaw(RotationUtil.getEnumRots(lastBlockData.face));
                        e.setPitch(80.5f);
                    }
                    break;
                case "side":
                    e.setYaw(MoveUtil.getPlrDir(mc.thePlayer.rotationYaw) - 145);
                    e.setPitch(MathUtil.randomFloat(83.5f, 77.5f));
                    break;
            }
            RotationUtil.visualRotations(e.getYaw(), e.getPitch());
            switch (towerMode.getMode()) {
                case "watchdog":
                    if (e.isPre() && mc.gameSettings.keyBindJump.pressed) {
                        switch ((int) mc.thePlayer.offGroundTicks) {
                            case 0:
                                mc.thePlayer.jump();
                                e.setOnGround(true);
                                break;

                            case 1:
                                mc.thePlayer.motionY = 0.33;
                                break;

                            case 2:
                                mc.thePlayer.motionY = 1 - mc.thePlayer.posY % 1;
                                mc.thePlayer.offGroundTicks = -1;
                                e.setOnGround(true);
                        }
                    }
                    break;
                case "NCP":
                    if (mc.gameSettings.keyBindJump.isKeyDown() && !mc.gameSettings.keyBindForward.isKeyDown()) {

                        if (mc.thePlayer.onGround) {
                            mc.thePlayer.motionY = 0.42;
                        } else if (mc.thePlayer.motionY < 0.22) {
                            mc.thePlayer.setPosition(mc.thePlayer.posX, (int) mc.thePlayer.posY, mc.thePlayer.posZ);
                            mc.thePlayer.motionY = 0.42;
                        }
                    }
                    break;
                case "verus":
                    if (mc.gameSettings.keyBindJump.isKeyDown()) {
                        mc.thePlayer.motionY = MathUtil.randomFloat(0.52f, 0.42f);
                        MoveUtil.strafe(0.33);
                    }
                    break;
                case "vanilla":
                    if (mc.gameSettings.keyBindJump.isKeyDown()) {
                        mc.thePlayer.motionY = 0.42f;
                    }
                    break;
            }
            switch (sprintMode.getMode()) {
                case "watchdog":
                    mc.thePlayer.setSprinting(mc.thePlayer.onGround && mc.thePlayer.moveForward > 0 && !mc.gameSettings.keyBindJump.pressed);
                    break;
                case "hvh":
                    MoveUtil.strafe(0.35);
                    break;
            }
        }
    }

    @EventTarget
    public void onUpdateEvent(EventUpdate e) {
        BlockPos blockPos = new BlockPos(mc.thePlayer.posX, mc.thePlayer.posY - 1, mc.thePlayer.posZ);
        if (blockData != null && lastBlockData != null) {
            place(blockPos);
            place(blockPos);
        }
        blockData = null;
    }

    public static int getBlockSlot() {
        for (int i = 0; i < 9; i++) {
            final ItemStack itemStack = mc.thePlayer.inventory.mainInventory[i];
            if (itemStack == null) {
                continue;
            }
            if (itemStack.getItem() instanceof ItemBlock && itemStack.stackSize > 0) {
                final ItemBlock itemBlock = (ItemBlock) itemStack.getItem();
                if (isBlockValid(itemBlock.getBlock())) {
                    return i;
                }
            }
        }
        return -1;
    }

    private static boolean isBlockValid(final Block block) {
        return (block.isFullBlock() || block == Blocks.glass) &&
                block != Blocks.sand &&
                block != Blocks.gravel &&
                block != Blocks.dispenser &&
                block != Blocks.command_block &&
                block != Blocks.noteblock &&
                block != Blocks.furnace &&
                block != Blocks.crafting_table &&
                block != Blocks.tnt &&
                block != Blocks.dropper &&
                block != Blocks.beacon;
    }

    private boolean isEmptyBlock(BlockPos pos) {
        return mc.theWorld.getBlockState(pos).getBlock() instanceof BlockAir;
    }

    private void place(BlockPos blockPos) {
        if (!isEmptyBlock(blockPos)) {
            return;
        }

        int slot = getBlockSlot();
        if (blockData == null || lastBlockData == null || slot == -1) {
            return;
        }

        ItemStack itemStack = mc.thePlayer.inventory.mainInventory[slot];
        if (itemStack == null || itemStack.stackSize == 0) {
            return;
        }

        if (mc.thePlayer.inventory.currentItem != slot) {
            mc.thePlayer.inventory.currentItem = slot;
        }

        interactWithBlock();
        mc.thePlayer.swingItem();
    }

    private void interactWithBlock() {
        if (sprintMode.is("Vulcan")) {
            if (mc.playerController.onPlayerRightClick(mc.thePlayer, mc.theWorld, mc.thePlayer.getHeldItem(), lastBlockData.pos, lastBlockData.face, new Vec3(lastBlockData.pos.getX(), lastBlockData.pos.getY(), lastBlockData.pos.getZ()))) {
                mc.thePlayer.swingItem();
                System.out.println("pos: " + lastBlockData.pos + "facing: " + lastBlockData.face);
            }
        } else {
            if (mc.playerController.onPlayerRightClick(mc.thePlayer, mc.theWorld, mc.thePlayer.getHeldItem(), lastBlockData.pos, lastBlockData.face, vec3(lastBlockData))) {
                mc.thePlayer.swingItem();
                System.out.println("pos: " + lastBlockData.pos + "facing: " + lastBlockData.face);
            }
        }
    }

    @EventTarget
    public void onSendPacket(EventSendPacket e) {
        if (sprintMode.is("watchdog")) {
            if (e.getPacket() instanceof C0BPacketEntityAction) {
                C0BPacketEntityAction c0b = (C0BPacketEntityAction) e.getPacket();
                if (c0b.getAction() == C0BPacketEntityAction.Action.START_SPRINTING || c0b.getAction() == C0BPacketEntityAction.Action.STOP_SPRINTING) {
                    e.setCancelled(true);
                }
            }
        }
    }

    public static Vec3 vec3(BlockData data) {
        BlockPos pos = data.pos;
        EnumFacing face = data.face;

        double x = pos.getX() + 0.4;
        double y = pos.getY() + 0.4;
        double z = pos.getZ() + 0.4;
        switch (face) {
            case UP:
                y += 0.6;
                break;
            case DOWN:
                y -= 0.2;
                break;
            case WEST:
                z += 0.1;
                break;
            case EAST:
                z += 0.7;
                break;
            case SOUTH:
                x += 0.7;
                break;
            case NORTH:
                x += 0.1;
                break;
        }
        return new Vec3(x, y, z);
    }

    private BlockData getBlockPos() {
        BlockPos pos = new BlockPos(mc.thePlayer.posX, mc.thePlayer.posY - 1, mc.thePlayer.posZ);
        BlockData blockData = checkBlock(pos);
        if (blockData != null) {
            return blockData;
        }
        for (int x = -1; x <= 1; x++) {
            for (int z = -1; z <= 1; z++) {
                if (x == 0 && z == 0) continue;

                BlockPos pos2 = pos.add(x, 0, z);
                blockData = checkBlock(pos2);
                if (blockData != null) {
                    return blockData;
                }
            }
        }
        return null;
    }

    private BlockData checkBlock(BlockPos pos) {
        IBlockState blockState = mc.theWorld.getBlockState(pos);
        if (blockState.getBlock() instanceof BlockAir) {
            for (final EnumFacing face : EnumFacing.values()) {
                IBlockState offsetBlockState = mc.theWorld.getBlockState(pos.offset(face));
                if (offsetBlockState.getBlock().getMaterial().isSolid() && !offsetBlockState.getBlock().getMaterial().isLiquid())
                    return new BlockData(face.getOpposite(), pos.offset(face));
            }
        }
        return null;
    }

    @Getter
    @Setter
    @AllArgsConstructor
    private static class BlockData {
        EnumFacing face;
        BlockPos pos;
    }
}
