package dev.bliss.impl.module;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.events.EventE;
import dev.bliss.api.setting.Setting;
import dev.bliss.api.setting.impl.SettingMode;
import dev.bliss.impl.module.impl.Dragable;
import dev.bliss.impl.module.impl.combat.*;
import dev.bliss.impl.module.impl.exploit.DisablerMod;
import dev.bliss.impl.module.impl.movement.*;
import dev.bliss.impl.module.impl.other.*;
import dev.bliss.impl.module.impl.player.*;
import dev.bliss.impl.module.impl.visual.*;

import java.util.*;

public class ModuleManager
{
    private static ArrayList<Module> modules;
    private static ArrayList<Module> draggable = new ArrayList<>();

    public ModuleManager() {

        // <-- Combat
        modules.add(new KillAuraMod());
        modules.add(new VelocityMod());
        modules.add(new NoHitDelayMod());

        // <-- Movement
        modules.add(new StepMod());
        modules.add(new SpeedMod());
        modules.add(new SprintMod());
        modules.add(new NoSlowMod());
        modules.add(new FlightMod());

        // <-- Player
        modules.add(new FastPlaceMod());
        modules.add(new ScaffoldMod());
        modules.add(new StealerMod());
        modules.add(new ManagerMod());

        // <-- Other
        modules.add(new SpinbotMod());
        modules.add(new ExampleMod());
        modules.add(new TimerMod());

        // <-- Visual
        modules.add(new ClickGuiMod());
        modules.add(new HudMod());
        modules.add(new EspMod());
        modules.add(new AnimationsMod());
        modules.add(new TargetHUDMod());
        modules.add(new FullbrightMod());

        // <-- Exploit
        modules.add(new DisablerMod());

        for (Module m : modules) {
            if (m instanceof Dragable) {
                draggable.add(m);
            }
        }
    }

    public ArrayList<Module> getDraggable() {
        return draggable;
    }

    public Module[] getModulesInCategory(final Category moduleCategory) {
        return ModuleManager.modules.stream().filter(module -> module.getCategory() == moduleCategory).toArray(Module[]::new);
    }

    public Module[] getModulesList() {
        return ModuleManager.modules.toArray(new Module[0]);
    }


    public void onUpdate() {
        for (final Module m : ModuleManager.modules) {
            m.onUpdate();
        }
    }

    public void onEvent(final EventE e) {
        for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
            if (!m.toggled) {
                continue;
            }
            m.onEvent(e);
        }
    }

    public SettingMode getModeSetByName(final String moduleName, final String settingName) {
        for (final Module m : this.getModules()) {
            if (m.name.equalsIgnoreCase(moduleName)) {
                for (final Setting s : m.settings) {
                    if (s.name.equalsIgnoreCase(settingName)) {
                        return (SettingMode)s;
                    }
                }
            }
        }
        return null;
    }

    public Module getMod(final String name) {
        return ModuleManager.modules.stream().filter(module -> module.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static <T extends Module> T getModule(final Class<T> clazz) {
        return (T)ModuleManager.modules.stream().filter(mod -> mod.getClass() == clazz).findFirst().orElse(null);
    }

    public ArrayList<Module> getModulesByCategory(final Category c) {
        final ArrayList<Module> modules = new ArrayList<Module>();
        final ModuleManager moduleManager = BloomReborn.INSTANCE.moduleManager;
        for (final Module m : ModuleManager.modules) {
            if (m.category == c) {
                modules.add(m);
            }
        }
        return modules;
    }

    public static ArrayList<Module> getModules() {
        return ModuleManager.modules;
    }

    public static ArrayList<Module> getEnabledModules() {
         ArrayList<Module> mods = new ArrayList<>();
         for (Module m : getModules()) {
             if (m.isEnabled()) mods.add(m);
         }
         return mods;
    }

    public Module getModuleByName(final String name) {
        return ModuleManager.modules.stream().filter(module -> module.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public final Module getModuleOrNull(final Class clazz) {
        final List modules = ModuleManager.modules;
        for (int i = 0, modulesSize = modules.size(); i < modulesSize; ++i) {
            final Module module = (Module) modules.get(i);
            if (module.getClass() == clazz) {
                return module;
            }
        }
        return null;
    }

    static {
        ModuleManager.modules = new ArrayList<Module>();
    }
}
