package dev.bliss.impl.module;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.Event;
import dev.bliss.api.script.Script;
import dev.bliss.api.setting.Setting;
import dev.bliss.api.util.client.Priority;
import dev.bliss.api.util.player.PositionUtil;
import dev.bliss.api.util.render.anim.Translate;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.client.*;
import net.minecraft.client.entity.*;
import java.util.*;
import net.minecraft.util.*;
import org.lwjgl.input.Keyboard;

@Setter
@Getter
public class Module
{
    private String arrayName;
    protected static Random rand;
    protected static Minecraft mc;
    public static EntityPlayerSP localPlayer;
    public boolean visible;
    private double transition;
    private boolean beingEnabled;
    private long stateChange;
    private long animationStartTime;
    private double verticalTransition;
    public double scaleFactor;
    private boolean expanded;
    public float offsetY;
    public float offsetX;
    public List<Setting> settings;
    public String name;
    public String suffix;
    public String hidden;
    public String displayName;
    public Priority priority;
    private int key;
    public Category category;
    public boolean toggled;
    public final Translate translate = new Translate(0.0, 0.0);

    // <-- Normal Module
    public Module(final String name, final int key, final Category category, Priority priority) {
        this.mc = Minecraft.getMinecraft();
        this.visible = true;
        this.beingEnabled = false;
        this.settings = new ArrayList<Setting>();
        this.name = name;
        this.suffix = "";
        this.key = key;
        this.priority = priority;
        this.category = category;
        this.toggled = false;
        this.setup();
    }

    // <-- Script Module
    public Module(final String name, final Category category, Priority priority) {
        this.mc = Minecraft.getMinecraft();
        this.visible = true;
        this.beingEnabled = false;
        this.settings = new ArrayList<Setting>();
        this.name = name;
        this.suffix = "";
        this.key = key;
        this.priority = priority;
        this.category = category;
        this.toggled = false;
    }
    
    public void addSettings(final Setting... settings) {
        this.settings.addAll(Arrays.asList(settings));
    }

    public void onEvent(final Event e) {
    }
    
    public boolean isEnabled() {
        return this.toggled;
    }

    public void onEnable() {
        if (this.getCategory() == Category.SCRIPT) {
            final Script script = BloomReborn.INSTANCE.scriptManager.getScriptByName(this.getName());
            script.callEvent("onEnable");
        }
        this.beingEnabled = true;
        this.verticalTransition = 0.0;
        this.transition = this.mc.fontRendererObj.getStringWidth(StringUtils.stripControlCodes(this.getDisplayName()));
        this.stateChange = System.currentTimeMillis();
        this.animationStartTime = this.stateChange;
        BloomReborn.INSTANCE.eventManager.register(this);
    }
    
    public void onUpdate() {
    }
    
    public void onDisable() {
        if (this.getCategory() == Category.SCRIPT) {
            final Script script = BloomReborn.INSTANCE.scriptManager.getScriptByName(this.getName());
            script.callEvent("onDisable");
        }
        this.beingEnabled = false;
        this.stateChange = System.currentTimeMillis();
        BloomReborn.INSTANCE.eventManager.unregister(this);
    }
    
    public void onToggle() {
    }
    
    public void toggle() {
        this.toggled = !this.toggled;
        if (this.toggled) {
            this.onEnable();
        }
        else {
            this.onDisable();
        }
    }
    
    public void setToggled(final boolean toggled) {
        this.toggled = toggled;
        if (this.toggled) {
            this.onEnable();
        }
        else {
            this.onDisable();
        }
    }

    public String getSuffixLowerCase() {
        return this.suffix.toLowerCase();
    }

    public String getKeyString() {
        if (this.key >= 0 && this.key < Keyboard.KEYBOARD_SIZE) {
            String keyName = Keyboard.getKeyName(this.key);
            return keyName;
        } else {
            return "UNKNOWN";
        }
    }

    public String getDisplayName() {
        return (this.displayName == null) ? this.name : this.displayName;
    }

    public void setup() {
    }

    public PositionUtil getPosition(){
        return null;
    }

    public void setPosition(double x, double y) {

    }
    
    static {
        Module.rand = new Random();
    }

}
