package dev.bliss.impl.command.impl;

import dev.bliss.BloomReborn;
import dev.bliss.api.file.FileManager;
import dev.bliss.impl.command.Command;
import dev.bliss.impl.module.Module;
import net.minecraft.util.EnumChatFormatting;

import java.io.File;
import java.util.Objects;

public class ConfigCmd extends Command
{
    public ConfigCmd() {
        super("Config", "Loads / Saves a config.", "config", new String[0]);
    }

    @Override
    public void onCommand(final String[] args, final String command) {
        if (args.length > 1) {
            final String type = args[0];
            final String name = args[1];
            final String s = type;
            switch (s) {
                case "save": {
                    BloomReborn.INSTANCE.addChatMessage("Saved the config " + EnumChatFormatting.RED + name + EnumChatFormatting.WHITE + ".");
                    try {
                        BloomReborn.INSTANCE.configManager.save(name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "load": {
                    BloomReborn.INSTANCE.addChatMessage("Loaded the config " + EnumChatFormatting.RED + name + EnumChatFormatting.WHITE + ".");
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        m.setToggled(false);
                    }
                    try {
                        BloomReborn.INSTANCE.configManager.load(name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "delete": {
                    try {
                        BloomReborn.INSTANCE.configManager.delete(name);
                    }
                    catch (Exception e) {
                        BloomReborn.INSTANCE.addChatMessage("Java just killed itself, contact river");
                    }
                    finally {
                        BloomReborn.INSTANCE.addChatMessage("Deleted config " + name + "!");
                    }
                    break;
                }
            }
        }
        else {
            try {
                final String type = args[0];
                if (type.equalsIgnoreCase("list")) {
                    BloomReborn.INSTANCE.addChatMessage("Config List:");
                    try {
                        for (final File archivogay : Objects.requireNonNull(Objects.requireNonNull(FileManager.INSTANCE.configDir).listFiles())) {
                            final String fileName = archivogay.getName().substring(0, archivogay.getName().length() - 5);
                            BloomReborn.INSTANCE.addChatMessage(fileName);
                        }
                    }
                    catch (NullPointerException exc) {
                        BloomReborn.INSTANCE.addChatMessage("No configs saved.");
                    }
                    BloomReborn.INSTANCE.addChatMessage("");
                }
            }
            catch (Exception e2) {
                BloomReborn.INSTANCE.addChatMessage("Usage: .config save/load [name]");
            }
        }
    }
}
