package dev.bliss.impl.command.impl;

import dev.bliss.BloomReborn;
import dev.bliss.impl.command.Command;
import dev.bliss.impl.module.Module;
import org.lwjgl.input.Keyboard;

public class BindCmd extends Command {

    public BindCmd() {
        super("Bind", "Binds a module to a key", "bind", new String[]{"module", "key"});
    }

    @Override
    public void onCommand(final String[] args, final String command) {
        final Module[] modules = BloomReborn.INSTANCE.getModuleManager().getModulesList();
        for (final Module module2 : modules) {
            if (args[0].equalsIgnoreCase(module2.getName())) {
                args[1] = args[1].toUpperCase();
                final int key = Keyboard.getKeyIndex(args[1]);
                module2.setKey(key);
                BloomReborn.INSTANCE.addChatMessage("Set " + module2.getName() + "'s bind to " + Keyboard.getKeyName(key));
                return;
            }
        }

        String module = args[0];
        String key = args[1];

        // Your code to bind the module to the key goes here

        BloomReborn.INSTANCE.addChatMessage("Module " + module + " is now bound to key " + key);
    }
}

