package dev.bliss.impl.command;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.events.EventChat;
import dev.bliss.impl.command.impl.BindCmd;
import dev.bliss.impl.command.impl.ConfigCmd;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Setter
@Getter
public class CommandManager
{
    public List<Command> commands;
    public String prefix;

    public CommandManager() {
        this.commands = new ArrayList<Command>();
        this.prefix = ".";
        this.setup();
    }

    public void setup() {
        commands.add(new ConfigCmd());
        commands.add(new BindCmd());
    }

    public void handleChat(final EventChat e) {
        String message = e.getMessage();
        if (!message.startsWith(this.prefix)) {
            return;
        }
        e.setCancelled(true);
        message = message.substring(this.prefix.length());
        boolean foundCommand = false;
        if (message.split(" ").length > 0) {
            final String commandName = message.split(" ")[0];
            for (final Command c : this.commands) {
                if (c.aliases.contains(commandName) || c.name.equalsIgnoreCase(commandName)) {
                    c.onCommand(Arrays.copyOfRange(message.split(" "), 1, message.split(" ").length), message);
                    foundCommand = true;
                    break;
                }
            }
        }
        if (!foundCommand) {
            BloomReborn.INSTANCE.addChatMessage("Could find the command, try .help for a list of commands.");
        }
    }
}
