package dev.bliss.impl.command;

import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Setter
@Getter
public abstract class Command
{
    public String name;
    public String description;
    public String syntax;
    public List<String> aliases;

    public Command(final String name, final String description, final String syntax, final String... aliases) {
        this.aliases = new ArrayList<String>();
        this.name = name;
        this.description = description;
        this.syntax = syntax;
        this.aliases = Arrays.asList(aliases);
    }

    public abstract void onCommand(final String[] p0, final String p1);

}
