package dev.bliss.api.util.server;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.events.EventTick;
import lombok.Getter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.network.OldServerPinger;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

import static dev.bliss.BloomReborn.mc;

@Getter
public class PingUtil
{
    public static long SERVER_UPDATE_TIME = 30000;

    private final OldServerPinger serverPinger;
    private final Map<String, Long> serverUpdateTime;
    private final Map<String, Boolean> serverUpdateStatus;

    private Long serverPing;

    public void onTickEvent(EventTick event) {
        updateManually(Minecraft.getMinecraft().getCurrentServerData());
    }

    public PingUtil() {
        this.serverPinger = new OldServerPinger();
        this.serverUpdateTime = new HashMap<>();
        this.serverUpdateStatus = new HashMap<>();
        this.serverPing = null;
        BloomReborn.INSTANCE.eventManager.register(this);
    }

    public static String getPing() {
        int latency = 0;
        if (!mc.isSingleplayer()) {
            NetworkPlayerInfo info = mc.getNetHandler().getPlayerInfo(mc.thePlayer.getUniqueID());
            if (info != null) latency = info.getResponseTime();

            if (ServerUtil.isOnHypixel() && latency == 1) {
                int temp = BloomReborn.INSTANCE.getPingUtil().getServerPing().intValue();
                if (temp != -1) {
                    latency = temp;
                }
            }
        }
        return latency == 0 ? "0" : String.valueOf(latency);
    }

    public void updateManually(ServerData server) {
        if (server != null) {
            Long updateTime = serverUpdateTime.get(server.serverIP);
            if ((updateTime == null || updateTime + SERVER_UPDATE_TIME <= System.currentTimeMillis()) && !serverUpdateStatus.getOrDefault(server.serverIP, false)) {
                serverUpdateStatus.put(server.serverIP, true);

                new Thread(() -> {
                    try {
                        serverPinger.ping(server);
                    } catch (UnknownHostException e) {
                        e.printStackTrace();
                    }

                    serverUpdateStatus.put(server.serverIP, false);
                    serverUpdateTime.put(server.serverIP, System.currentTimeMillis());
                }).start();
            }

            if (!ServerUtil.isOnHypixel() || server.pingToServer != 1) {
                serverPing = server.pingToServer;
            }
        }
    }
}
