package dev.bliss.api.util.server;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.events.EventSendPacket;
import net.minecraft.network.Packet;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.login.client.C00PacketLoginStart;
import net.minecraft.network.login.client.C01PacketEncryptionResponse;
import net.minecraft.network.play.client.*;
import net.minecraft.network.status.client.C00PacketServerQuery;
import net.minecraft.network.status.client.C01PacketPing;

import java.util.LinkedList;

import static dev.bliss.BloomReborn.mc;

public class BlinkUtil {
    private static final LinkedList<Packet<?>> packets = new LinkedList<>();

    public static void resetAll() {
        if (!packets.isEmpty()) {
            packets.forEach(PacketUtil::sendPacketNoEvent);
            packets.clear();
        }
    }

    public static void CancelAll(final EventSendPacket eventPacket) {
        if (mc.theWorld == null) {
            return;
        }

        if (eventPacket.getPacket() instanceof C01PacketChatMessage || eventPacket.getPacket() instanceof C14PacketTabComplete
                || eventPacket.getPacket() instanceof C01PacketEncryptionResponse || eventPacket.getPacket() instanceof C01PacketPing
                || eventPacket.getPacket() instanceof C00PacketLoginStart || eventPacket.getPacket() instanceof C00PacketServerQuery
                || eventPacket.getPacket() instanceof C00Handshake
        ) {
            return;
        }

        if (!eventPacket.isCancelled()) {
            packets.add(eventPacket.getPacket());
            eventPacket.setCancelled(true);
        }
    }

    public static void CancelVulcan(final EventSendPacket eventPacket) {
        if (mc.theWorld == null) {
            return;
        }

        if (eventPacket.getPacket() instanceof C01PacketChatMessage || eventPacket.getPacket() instanceof C14PacketTabComplete
                || eventPacket.getPacket() instanceof C01PacketEncryptionResponse || eventPacket.getPacket() instanceof C01PacketPing
                || eventPacket.getPacket() instanceof C00PacketLoginStart || eventPacket.getPacket() instanceof C00PacketServerQuery
                || eventPacket.getPacket() instanceof C00Handshake || eventPacket.getPacket() instanceof C02PacketUseEntity || eventPacket.getPacket() instanceof C00PacketKeepAlive
        ) {
            return;
        }

        if (!eventPacket.isCancelled()) {
            packets.add(eventPacket.getPacket());
            eventPacket.isCancelled();
        }
    }

    public static void CancelOther(final EventSendPacket eventPacket) {
        if (mc.theWorld == null) {
            return;
        }
        if (eventPacket.getPacket() instanceof C0FPacketConfirmTransaction || eventPacket.getPacket() instanceof C00PacketKeepAlive || eventPacket.getPacket() instanceof C01PacketChatMessage) {

        } else {
            packets.add(eventPacket.getPacket());
            eventPacket.setCancelled(true);
        }
    }

    public static void CancelTransactions(final EventSendPacket eventPacket) {
        if (mc.theWorld == null) {
            return;
        }
        if (eventPacket.getPacket() instanceof C0FPacketConfirmTransaction || eventPacket.getPacket() instanceof C00PacketKeepAlive || eventPacket.getPacket() instanceof C01PacketChatMessage) {
            packets.add(eventPacket.getPacket());
            eventPacket.setCancelled(true);
        }
    }

    public static void CancelHypixel(final EventSendPacket eventPacket) {
        if (mc.theWorld == null) {
            return;
        }

        if (eventPacket.getPacket() instanceof C01PacketChatMessage || eventPacket.getPacket() instanceof C14PacketTabComplete
                || eventPacket.getPacket() instanceof C01PacketEncryptionResponse || eventPacket.getPacket() instanceof C01PacketPing
                || eventPacket.getPacket() instanceof C00PacketLoginStart || eventPacket.getPacket() instanceof C00PacketServerQuery
                || eventPacket.getPacket() instanceof C00Handshake || eventPacket.getPacket() instanceof C0FPacketConfirmTransaction || eventPacket.getPacket() instanceof C00PacketKeepAlive
        ) {
            return;
        }

        if (!eventPacket.isCancelled()) {
            packets.add(eventPacket.getPacket());
            BloomReborn.INSTANCE.addChatMessage("cancel: " + eventPacket.getPacket());
            eventPacket.setCancelled(true);
        }
    }

    public static void CancelMove(EventSendPacket eventPacket) {
        if (mc.theWorld == null || eventPacket == null) {
            return;
        }
        if (eventPacket.getPacket() instanceof C03PacketPlayer || eventPacket.getPacket() instanceof C0BPacketEntityAction) {
            packets.add(eventPacket.getPacket());
            eventPacket.setCancelled(true);
        }
    }
}
