package dev.bliss.api.util.render.anim;

import lombok.Getter;

@Getter
public class Translate {

    private double x, y;

    public Translate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void animate(double targetx, double targety) {
        x = AnimateUtil.progressive(x, targetx, 1.0D);
        y = AnimateUtil.progressive(y, targety, 0.5D);
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

}
