package dev.bliss.api.util.render.anim;

import dev.bliss.api.util.math.MathUtil;
import net.minecraft.client.Minecraft;

public class AnimateUtil {

    public static float interpolate(float start, float end, float fraction) {
        float t = fraction;
        float tt = t * t;
        float ttt = tt * t;
        return start + (2 * ttt - 3 * tt + 1) * (end - start);
    }

    public static double progressive(double start, double end, double speed) {
        double dif = Math.abs(start - end);

        final int fps = Minecraft.getDebugFPS();

        if (dif > 0) {
            double animationSpeed = MathUtil.roundToDecimalPlace(Math.min(
                    10.0D, Math.max(0.05D, (144.0D / fps) * (dif / 10) * speed)), 0.05D);

            if (dif != 0 && dif < animationSpeed)
                animationSpeed = dif;

            if (start < end)
                return start + animationSpeed;
            else if (start > end)
                return start - animationSpeed;
        }

        return start;
    }

    public static double linear(double start, double end, double speed) {
        double dif = Math.abs(start - end);

        final int fps = Minecraft.getDebugFPS();

        if (dif > 0) {
            double animationSpeed = MathUtil.roundToDecimalPlace(Math.min(
                    10.0D, Math.max(0.005D, (144.0D / fps) * speed)), 0.005D);

            if (dif != 0 && dif < animationSpeed)
                animationSpeed = dif;

            if (start < end)
                return start + animationSpeed;
            else if (start > end)
                return start - animationSpeed;
        }

        return start;
    }

}
