package dev.bliss.api.util.render;

import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

import static dev.bliss.api.util.render.Render2D.color;
import static org.lwjgl.opengl.GL11.glDisable;
import static org.lwjgl.opengl.GL11.glEnable;

public class RoundUtil
{
    public static void drawRoundedRect(float x, float y, float width, float height, float radius, int color) {

        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        double x1 = x + width;
        double y1 = y + height;
        float f = (color >> 24 & 0xFF) / 255.0F;
        float f1 = (color >> 16 & 0xFF) / 255.0F;
        float f2 = (color >> 8 & 0xFF) / 255.0F;
        float f3 = (color & 0xFF) / 255.0F;
        GL11.glPushAttrib(0);
        GL11.glScaled(0.5, 0.5, 0.5);

        x *= 2;
        y *= 2;
        x1 *= 2;
        y1 *= 2;

        glDisable(GL11.GL_TEXTURE_2D);
        GL11.glColor4f(f1, f2, f3, f);
        glEnable(GL11.GL_LINE_SMOOTH);

        GL11.glBegin(GL11.GL_POLYGON);

        for (int i = 0; i <= 90; i += 3) {
            GL11.glVertex2d(x + radius + +(Math.sin((i * Math.PI / 180)) * (radius * -1)), y + radius + (Math.cos((i * Math.PI / 180)) * (radius * -1)));
        }

        for (int i = 90; i <= 180; i += 3) {
            GL11.glVertex2d(x + radius + (Math.sin((i * Math.PI / 180)) * (radius * -1)), y1 - radius + (Math.cos((i * Math.PI / 180)) * (radius * -1)));
        }

        for (int i = 0; i <= 90; i += 3) {
            GL11.glVertex2d(x1 - radius + (Math.sin((i * Math.PI / 180)) * radius), y1 - radius + (Math.cos((i * Math.PI / 180)) * radius));
        }

        for (int i = 90; i <= 180; i += 3) {
            GL11.glVertex2d(x1 - radius + (Math.sin((i * Math.PI / 180)) * radius), y + radius + (Math.cos((i * Math.PI / 180)) * radius));
        }

        GL11.glEnd();

        glEnable(GL11.GL_TEXTURE_2D);
        glDisable(GL11.GL_LINE_SMOOTH);
        glEnable(GL11.GL_TEXTURE_2D);

        GL11.glScaled(2, 2, 2);

        GL11.glPopAttrib();
        GL11.glColor4f(1, 1, 1, 1);
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();

    }
    public static void drawBorderedRoundedRect(float x, float y, float width, float height, float radius, float linewidth, int insideC, int borderC) {
        drawRoundedRect(x, y, width, height, radius, borderC);
        drawOutlinedRoundedRect(x, y, width, height, radius, linewidth, insideC);
    }
    public static void drawGradientRoundRect(double x, double y, double x1, double y1, int color1, int color2, double radius) {
        if (x1 < x) {
            double temp = x;
            x = x1;
            x1 = temp;
        }
        if (y1 < y) {
            double temp = y;
            y = y1;
            y1 = temp;
        }
        float alpha = (float) (color1 >> 24 & 255)/255F;
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
        GlStateManager.disableTexture2D();
        GlStateManager.disableCull();
        GlStateManager.disableAlpha();
        GlStateManager.disableDepth();


        GL11.glShadeModel(GL11.GL_SMOOTH);
        GL11.glBegin(GL11.GL_TRIANGLE_FAN);

        double xs = x+radius;
        double ys = y+radius;
        color(ColorUtil.getAlphaColor(ColorUtil.blend(color1,color2,Math.sin(Math.toRadians(System.nanoTime()/1000000/7 + 0))+1, 2), (int) (alpha*100)));
        for (double i = 270; i < 360; i+=2) {
            GL11.glVertex2d(xs + Math.sin(i * Math.PI / 180) * radius, ys - Math.cos(i * Math.PI / 180) * radius);
        }
        color(ColorUtil.getAlphaColor(ColorUtil.blend(color1,color2,Math.sin(Math.toRadians(System.nanoTime()/1000000/7 + 90))+1, 2), (int) (alpha*100)));
        xs = x1-radius;
        ys = y+radius;
        for (double i = 0; i < 90; i+=2) {
            GL11.glVertex2d(xs + Math.sin(i * Math.PI / 180) * radius, ys - Math.cos(i * Math.PI / 180) * radius);
        }

        xs = x1-radius;
        ys = y1-radius;
        color(ColorUtil.getAlphaColor(ColorUtil.blend(color1,color2,Math.sin(Math.toRadians(System.nanoTime()/1000000/7 + 180))+1, 2), (int) (alpha*100)));
        for (double i = 90; i < 180; i+=2) {
            GL11.glVertex2d(xs + Math.sin(i * Math.PI / 180) * radius, ys - Math.cos(i * Math.PI / 180) * radius);
        }
        color(ColorUtil.getAlphaColor(ColorUtil.blend(color1,color2,Math.sin(Math.toRadians(System.nanoTime()/1000000/7 + 260))+1, 2), (int) (alpha*100)));
        xs = x+radius;
        ys = y1-radius;
        for (double i = 180; i < 270; i+=2) {
            GL11.glVertex2d(xs + Math.sin(i * Math.PI / 180) * radius, ys - Math.cos(i * Math.PI / 180) * radius);
        }

        GL11.glEnd();

        GL11.glShadeModel(GL11.GL_FLAT);

        GlStateManager.enableDepth();
        GlStateManager.enableAlpha();
        GlStateManager.enableCull();
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        GlStateManager.resetColor();
    }
    public static void drawOutlinedRoundedRect(double x, double y, double width, double height, double radius, float linewidth, int color) {
        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        double x1 = x + width;
        double y1 = y + height;
        float f = (color >> 24 & 0xFF) / 255.0F;
        float f1 = (color >> 16 & 0xFF) / 255.0F;
        float f2 = (color >> 8 & 0xFF) / 255.0F;
        float f3 = (color & 0xFF) / 255.0F;
        GL11.glPushAttrib(0);
        GL11.glScaled(0.5, 0.5, 0.5);

        x *= 2;
        y *= 2;
        x1 *= 2;
        y1 *= 2;
        GL11.glLineWidth(linewidth);

        glDisable(GL11.GL_TEXTURE_2D);
        GL11.glColor4f(f1, f2, f3, f);
        glEnable(GL11.GL_LINE_SMOOTH);
        GL11.glBegin(2);

        for (int i = 0; i <= 90; i += 3) {
            GL11.glVertex2d(x + radius + +(Math.sin((i * Math.PI / 180)) * (radius * -1)), y + radius + (Math.cos((i * Math.PI / 180)) * (radius * -1)));
        }

        for (int i = 90; i <= 180; i += 3) {
            GL11.glVertex2d(x + radius + (Math.sin((i * Math.PI / 180)) * (radius * -1)), y1 - radius + (Math.cos((i * Math.PI / 180)) * (radius * -1)));
        }

        for (int i = 0; i <= 90; i += 3) {
            GL11.glVertex2d(x1 - radius + (Math.sin((i * Math.PI / 180)) * radius), y1 - radius + (Math.cos((i * Math.PI / 180)) * radius));
        }

        for (int i = 90; i <= 180; i += 3) {
            GL11.glVertex2d(x1 - radius + (Math.sin((i * Math.PI / 180)) * radius), y + radius + (Math.cos((i * Math.PI / 180)) * radius));
        }

        GL11.glEnd();

        glEnable(GL11.GL_TEXTURE_2D);
        glDisable(GL11.GL_LINE_SMOOTH);
        glEnable(GL11.GL_TEXTURE_2D);

        GL11.glScaled(2, 2, 2);

        GL11.glPopAttrib();
        GL11.glColor4f(1, 1, 1, 1);
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();

    }
}
