package dev.bliss.api.util.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

import java.awt.*;

import static dev.bliss.BloomReborn.mc;

public class Render2D
{
    public static void drawRect(final float x, final float y, final float x1, final float y1, final int color) {
        enableGL2D();
        glColor(color);
        drawRect(x, y, x1, y1);
        disableGL2D();
    }

    public static void prepareScissorBox(final double x, final double y, final double x2, final double y2) {
        final int factor = new ScaledResolution(Minecraft.getMinecraft()).getScaleFactor();
        GL11.glScissor((int)(x * factor), (int)((new ScaledResolution(Minecraft.getMinecraft()).getScaledHeight() - y2) * factor), (int)((x2 - x) * factor), (int)((y2 - y) * factor));
    }

    public static void rectangleBordered(final double x, final double y, final double x1, final double y1, final double width, final int internalColor, final int borderColor) {
        rectangle(x + width, y + width, x1 - width, y1 - width, internalColor);
        rectangle(x + width, y, x1 - width, y + width, borderColor);
        rectangle(x, y, x + width, y1, borderColor);
        rectangle(x1 - width, y, x1, y1, borderColor);
        rectangle(x + width, y1 - width, x1 - width, y1, borderColor);
    }

    public static void rectangle(final double left, final double top, final double right, final double bottom, final int color) {
        Gui.drawRect(left, top, right, bottom, color);
    }

    public static void drawRect2(double left, double top, double right, double bottom, final int color) {
        if (left < right) {
            final double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            final double j = top;
            top = bottom;
            bottom = j;
        }
        final float f3 = (color >> 24 & 0xFF) / 255.0f;
        final float f4 = (color >> 16 & 0xFF) / 255.0f;
        final float f5 = (color >> 8 & 0xFF) / 255.0f;
        final float f6 = (color & 0xFF) / 255.0f;
        final Tessellator tessellator = Tessellator.getInstance();
        final WorldRenderer worldrenderer = tessellator.getWorldRenderer();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.color(f4, f5, f6, f3);
        worldrenderer.begin(7, DefaultVertexFormats.POSITION);
        worldrenderer.pos(left, bottom, 0.0).endVertex();
        worldrenderer.pos(right, bottom, 0.0).endVertex();
        worldrenderer.pos(right, top, 0.0).endVertex();
        worldrenderer.pos(left, top, 0.0).endVertex();
        tessellator.draw();
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
    }

    public static void enableGL2D() {
        GL11.glDisable(2929);
        GL11.glEnable(3042);
        GL11.glDisable(3553);
        GL11.glBlendFunc(770, 771);
        GL11.glDepthMask(true);
        GL11.glEnable(2848);
        GL11.glHint(3154, 4354);
        GL11.glHint(3155, 4354);
    }

    public static void disableGL2D() {
        GL11.glEnable(3553);
        GL11.glDisable(3042);
        GL11.glEnable(2929);
        GL11.glDisable(2848);
        GL11.glHint(3154, 4352);
        GL11.glHint(3155, 4352);
    }

    public static double interpolate(final double old, final double now, final float partialTicks) {
        return old + (now - old) * partialTicks;
    }

    public static void color(int color) {
        float f3 = (float) (color >> 24 & 255) / 255.0F;
        float f = (float) (color >> 16 & 255) / 255.0F;
        float f1 = (float) (color >> 8 & 255) / 255.0F;
        float f2 = (float) (color & 255) / 255.0F;
        GlStateManager.color(f, f1, f2, f3);
    }

    public static void drawFace(final int x, final int y, final float u, final float v, final int uWidth, final int vHeight, final int width, final int height, final float tileWidth, final float tileHeight, final AbstractClientPlayer target) {
        try {
            final ResourceLocation skin = target.getLocationSkin();
            Minecraft.getMinecraft().getTextureManager().bindTexture(skin);
            GL11.glEnable(3042);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            Gui.drawScaledCustomSizeModalRect(x, y, u, v, uWidth, vHeight, width, height, tileWidth, tileHeight);
            GL11.glDisable(3042);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawCircle(final double d, final double e, final float r, final int c) {
        final float f = (c >> 24 & 0xFF) / 255.0f;
        final float f2 = (c >> 16 & 0xFF) / 255.0f;
        final float f3 = (c >> 8 & 0xFF) / 255.0f;
        final float f4 = (c & 0xFF) / 255.0f;
        GL11.glPushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GL11.glEnable(2848);
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GL11.glColor4f(f2, f3, f4, f);
        GL11.glBegin(6);
        for (int i = 0; i <= 360; ++i) {
            final double x2 = Math.sin(i * 3.141592653589793 / 180.0) * (r / 2.0f);
            final double y2 = Math.cos(i * 3.141592653589793 / 180.0) * (r / 2.0f);
            GL11.glVertex2d(d + r / 2.0f + x2, e + r / 2.0f + y2);
        }
        GL11.glEnd();
        GL11.glBegin(2);
        for (int i = 0; i <= 360; ++i) {
            final double x2 = Math.sin(i * 3.141592653589793 / 180.0) * (r / 2.0f);
            final double y2 = Math.cos(i * 3.141592653589793 / 180.0) * (r / 2.0f);
            GL11.glVertex2d(d + r / 2.0f + x2, e + r / 2.0f + y2);
        }
        GL11.glEnd();
        GL11.glDisable(2848);
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        GL11.glPopMatrix();
    }

    public static void glColor(final int hex) {
        final float alpha = (hex >> 24 & 0xFF) / 255.0f;
        final float red = (hex >> 16 & 0xFF) / 255.0f;
        final float green = (hex >> 8 & 0xFF) / 255.0f;
        final float blue = (hex & 0xFF) / 255.0f;
        GL11.glColor4f(red, green, blue, alpha);
    }

    public static void drawRect(final float x, final float y, final float x1, final float y1) {
        GL11.glBegin(7);
        GL11.glVertex2f(x, y1);
        GL11.glVertex2f(x1, y1);
        GL11.glVertex2f(x1, y);
        GL11.glVertex2f(x, y);
        GL11.glEnd();
    }

    public static void drawBorderedRect(final double x, final double y, final double width, final double height, final double lineSize, final int borderColor, final int color) {
        Gui.drawRect(x, y, x + width, y + height, color);
        Gui.drawRect(x, y, x + width, y + lineSize, borderColor);
        Gui.drawRect(x, y, x + lineSize, y + height, borderColor);
        Gui.drawRect(x + width, y, x + width - lineSize, y + height, borderColor);
        Gui.drawRect(x, y + height, x + width, y + height - lineSize, borderColor);
    }

    public static void drawArc(float x, float y, float radius, int startAngle, int endAngle) {
        GL11.glBegin(GL11.GL_TRIANGLE_FAN);
        for (int i = startAngle; i <= endAngle; i++) {
            double rad = (i * Math.PI) / 180;
            GL11.glVertex2f(x + (float) Math.cos(rad) * radius, y + (float) Math.sin(rad) * radius);
        }
        GL11.glEnd();
    }
    public static void drawGradientRectHoriz(double x, double y, double x1, double y1, int color, int color2) {

        Gui.drawGradientRectHoriz(x, y, x1, y1, color, color2);
    }
    public static void drawRoundedRectGradient(float x, float y, float x1, float y1, float radius, int startColor, int endColor) {
        enableGL2D();

        drawRect(x + radius, y + radius, x1 - radius, y1 - radius);

        drawArc(x + radius, y + radius, radius, 0, 90);
        drawArc(x1 - radius, y1 - radius, radius, 180, 270);
        drawArc(x + radius, y1 - radius, radius, 90, 180);
        drawArc(x1 - radius, y + radius, radius, 270, 360);


        drawGradientRect(x + radius, y, x1 - radius, y + radius, startColor, endColor);
        drawGradientRect(x + radius, y1 - radius, x1 - radius, y1, startColor, endColor);
        drawGradientRect(x, y + radius, x + radius, y1 - radius, startColor, endColor);
        drawGradientRect(x1 - radius, y + radius, x1, y1 - radius, startColor, endColor);

        disableGL2D();
    }

    public static void drawRoundedRectGradient(double x, double y, double x1, double y1, double radius, int startColor, int endColor) {
        enableGL2D();

        drawRect((float) (x + radius), (float) (y + radius), (float) (x1 - radius), (float) (y1 - radius));

        drawArc((float) (x + radius), (float) (y + radius), (float) radius, 0, 90);
        drawArc((float) (x1 - radius), (float) (y1 - radius), (float) radius, 180, 270);
        drawArc((float) (x + radius), (float) (y1 - radius), (float) radius, 90, 180);
        drawArc((float) (x1 - radius), (float) (y + radius), (float) radius, 270, 360);


        drawGradientRect((float) (x + radius), (float) y, (float) (x1 - radius), (float) (y + radius), startColor, endColor);
        drawGradientRect((float) (x + radius), (float) (y1 - radius), (float) (x1 - radius), (float) y1, startColor, endColor);
        drawGradientRect((float) x, (float) (y + radius), (float) (x + radius), (float) (y1 - radius), startColor, endColor);
        drawGradientRect((float) (x1 - radius), (float) (y + radius), (float) x1, (float) (y1 - radius), startColor, endColor);

        disableGL2D();
    }

    public static void drawGradientRect(float x, float y, float x1, float y1, int startColor, int endColor) {
        float startAlpha = (startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (startColor & 0xFF) / 255.0f;

        float endAlpha = (endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (endColor & 0xFF) / 255.0f;

        GL11.glBegin(GL11.GL_QUADS);
        GL11.glColor4f(startRed, startGreen, startBlue, startAlpha);
        GL11.glVertex2f(x, y1);
        GL11.glVertex2f(x1, y1);

        GL11.glColor4f(endRed, endGreen, endBlue, endAlpha);
        GL11.glVertex2f(x1, y);
        GL11.glVertex2f(x, y);
        GL11.glEnd();
    }

    public static void drawSkeetRect(final double x, final double y, final double x1, final double y1, final double width) {
        Render2D.rectangleBordered(x, y + -4.0, x1 + width, y1 + width, 0.5, new Color(60, 60, 60).getRGB(), new Color(10, 10, 10).getRGB());
        Render2D.rectangleBordered(x + 1.0, y + -3.0, x1 + width - 1.0, y1 + width - 1.0, 1.0, new Color(40, 40, 40).getRGB(), new Color(40, 40, 40).getRGB());
        Render2D.rectangleBordered(x + 2.5, y + -1.5, x1 + width - 2.5, y1 + width - 2.5, 0.5, new Color(40, 40, 40).getRGB(), new Color(60, 60, 60).getRGB());
        Render2D.rectangleBordered(x + 2.5, y + -1.5, x1 + width - 2.5, y1 + width - 2.5, 0.5, new Color(22, 22, 22).getRGB(), new Color(255, 255, 255, 0).getRGB());
    }

    public static void drawEntityModel(final float yaw, final float pitch, final EntityLivingBase entity) {
        // Reset OpenGL shit
        GlStateManager.resetColor();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableColorMaterial();

        //OpenGL transformations
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, 0.0f, 50.0f);
        GlStateManager.scale(-50.0f, 50.0f, 50.0f);
        GlStateManager.rotate(180.0f, 0.0f, 0.0f, 1.0f);

        // Store original entity rotations
        final float renderYawOffset = entity.renderYawOffset;
        final float rotationYaw = entity.rotationYaw;
        final float rotationPitch = entity.rotationPitch;
        final float prevRotationYawHead = entity.prevRotationYawHead;
        final float rotationYawHead = entity.rotationYawHead;

        // Adjust entity facing
        GlStateManager.rotate(135.0f, 0.0f, 1.0f, 0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.rotate(-135.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotate((float) (-Math.atan(pitch / 40.0f) * 20.0), 1.0f, 0.0f, 0.0f);
        entity.renderYawOffset = yaw - yaw / yaw * 0.4f;
        entity.rotationYaw = yaw - yaw / yaw * 0.2f;
        entity.rotationPitch = pitch;
        entity.rotationYawHead = entity.rotationYaw;
        entity.prevRotationYawHead = entity.rotationYaw;

        // Render the entity
        GlStateManager.translate(0.0f, 0.0f, 0.0f);
        final RenderManager renderManager = mc.getRenderManager();
        renderManager.setPlayerViewY(180.0f);
        renderManager.setRenderShadow(false);
        renderManager.renderEntityWithPosYaw(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        renderManager.setRenderShadow(true);

        // Restore original entity rotations
        entity.renderYawOffset = renderYawOffset;
        entity.rotationYaw = rotationYaw;
        entity.rotationPitch = rotationPitch;
        entity.prevRotationYawHead = prevRotationYawHead;
        entity.rotationYawHead = rotationYawHead;

        // Restore OpenGL state
        GlStateManager.popMatrix();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.disableRescaleNormal();
        GlStateManager.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GlStateManager.disableTexture2D();
        GlStateManager.setActiveTexture(OpenGlHelper.defaultTexUnit);
        GlStateManager.resetColor();
    }

}



