package dev.bliss.api.util.player;

import com.google.common.base.Predicates;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.*;
import net.optifine.reflect.Reflector;

import java.util.List;

import static dev.bliss.BloomReborn.mc;

public class RotationUtil {

    public static float serverYaw, serverPitch;
    public static boolean customrot;

    public static void visualRotations(float yaw, float pitch) {
        mc.thePlayer.rotationYawHead = mc.thePlayer.renderYawOffset = yaw;
        mc.thePlayer.rotationPitchHead = pitch;
    }

    public static float gcdFix() {
        float SENSITIVITY = mc.gameSettings.mouseSensitivity * 0.5F + 0.15f;
        return (SENSITIVITY * SENSITIVITY * SENSITIVITY) * 8.0F * 0.15F;
    }

    public static Vec3 getVectorForRotation(float pitch, float yaw)
    {
        float f = MathHelper.cos(-yaw * 0.017453292F - (float)Math.PI);
        float f1 = MathHelper.sin(-yaw * 0.017453292F - (float)Math.PI);
        float f2 = -MathHelper.cos(-pitch * 0.017453292F);
        float f3 = MathHelper.sin(-pitch * 0.017453292F);
        return new Vec3((f1 * f2), f3, (f * f2));
    }

    public static Entity rayTrace(double range, float[] rotations) {
        if(range == 3) {
            return mc.objectMouseOver.entityHit;
        }

        Vec3 vec3 = Minecraft.getMinecraft().thePlayer.getPositionEyes(1.0f);

        Vec3 vec31 = RotationUtil.getVectorForRotation(rotations[1], rotations[0]);
        Vec3 vec32 = vec3.addVector(vec31.xCoord * range, vec31.yCoord * range, vec31.zCoord * range);

        Entity pointedEntity = null;

        float f = 1.0F;
        List<?> list = Minecraft.getMinecraft().theWorld.getEntitiesInAABBexcluding(Minecraft.getMinecraft().getRenderViewEntity(), Minecraft.getMinecraft().getRenderViewEntity().getEntityBoundingBox().addCoord(vec31.xCoord * range, vec31.yCoord * range, vec31.zCoord * range).expand(f, f, f), Predicates.and(EntitySelectors.NOT_SPECTATING, Entity::canBeCollidedWith));
        double d2 = range;

        for (Object o : list) {
            Entity entity1 = (Entity) o;
            float f1 = entity1.getCollisionBorderSize();
            AxisAlignedBB axisalignedbb = entity1.getEntityBoundingBox().expand(f1, f1,  f1);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3, vec32);

            if (axisalignedbb.isVecInside(vec3)) {
                if (d2 >= 0.0D) {
                    pointedEntity = entity1;
                    d2 = 0.0D;
                }
            } else if (movingobjectposition != null) {
                double d3 = vec3.distanceTo(movingobjectposition.hitVec);

                if (d3 < d2 || d2 == 0.0D) {
                    boolean flag2 = false;

                    if (Reflector.ForgeEntity_canRiderInteract.exists()) {
                        flag2 = Reflector.callBoolean(entity1, Reflector.ForgeEntity_canRiderInteract);
                    }

                    if (entity1 == Minecraft.getMinecraft().getRenderViewEntity().ridingEntity && !flag2) {
                        if (d2 == 0.0D) {
                            pointedEntity = entity1;
                        }
                    } else {
                        pointedEntity = entity1;
                        d2 = d3;
                    }
                }
            }
        }

        return pointedEntity;
    }

    public static float[] getRotationsNeeded(final Entity entity) {
        final double differenceX = entity.posX - mc.thePlayer.posX;
        final double differenceY = (entity.posY + entity.height) - (mc.thePlayer.posY + mc.thePlayer.height) - 0.2;
        final double differenceZ = entity.posZ - mc.thePlayer.posZ;
        final float rotationYaw = (float) (Math.atan2(differenceZ, differenceX) * 180.0D / Math.PI) - 90.0f;
        final float rotationPitch = (float) (Math.atan2(differenceY, mc.thePlayer.getDistanceToEntity(entity)) * 180.0D
                / Math.PI);
        final float finishedYaw = mc.thePlayer.rotationYaw
                + MathHelper.wrapAngleTo180_float(rotationYaw - mc.thePlayer.rotationYaw);
        final float finishedPitch = mc.thePlayer.rotationPitch
                + MathHelper.wrapAngleTo180_float(rotationPitch - mc.thePlayer.rotationPitch);
        return new float[]{finishedYaw, -MathHelper.clamp_float(finishedPitch, -90, 90)};
    }

    public static float[] getRotations3d(final Entity entity, final double offsetX, final double offsetY, final double offsetZ) {
        final double differenceX = entity.posX + offsetX - mc.thePlayer.posX;
        final double differenceY = (entity.posY + offsetY + entity.height) - (mc.thePlayer.posY + mc.thePlayer.height) - 0.2 + offsetY;
        final double differenceZ = entity.posZ + offsetZ - mc.thePlayer.posZ;
        final float rotationYaw = (float) (Math.atan2(differenceZ, differenceX) * 180.0D / Math.PI) - 90.0f;
        final float rotationPitch = (float) (Math.atan2(differenceY, mc.thePlayer.getDistanceToEntity(entity)) * 180.0D / Math.PI);
        final float finishedYaw = mc.thePlayer.rotationYaw + MathHelper.wrapAngleTo180_float(rotationYaw - mc.thePlayer.rotationYaw);
        final float finishedPitch = mc.thePlayer.rotationPitch + MathHelper.wrapAngleTo180_float(rotationPitch - mc.thePlayer.rotationPitch);
        return new float[]{finishedYaw, -MathHelper.clamp_float(finishedPitch, -90, 90)};
    }

    public static float[] getKaRotations(EntityLivingBase entity, float yaw, float pitch, float yawSpeed, float pitchSpeed, double offsetX, double offsetY, double offsetZ)
    {
        if (entity == null)
        {
            yaw = mc.thePlayer.rotationYaw;
            pitch = mc.thePlayer.rotationPitch;
        }
        else
        {
            pitchSpeed *= 0.5;

            if (yawSpeed < 0)
            {
                yawSpeed *= -1;
            }

            if (pitchSpeed < 0)
            {
                pitchSpeed *= -1;
            }

            float sYaw = (float) interpolateRotation((float) yaw, (float) getRotations3d(entity, offsetX, offsetY, offsetZ)[0], yawSpeed);
            float sPitch = (float) interpolateRotation((float) pitch, (float) getRotations3d(entity, offsetX, offsetY, offsetZ)[1], pitchSpeed);
            yaw = interpolateRotation(yaw, sYaw, 360);
            pitch = interpolateRotation(pitch, sPitch, 360);

            if (pitch > 90)
            {
                pitch = 90;
            }
            else if (pitch < -90)
            {
                pitch = -90;
            }
        }

        return new float[] {yaw, pitch};
    }

    public static float interpolateRotation(final float current, final float predicted, float percentage) {
        final float f = MathHelper.wrapAngleTo180_float(predicted - current);
        if (f <= 10.0f && f >= -10.0f) {
            percentage = 1.0f;
        }
        return current + percentage * f;
    }
    public static float getEnumRots(EnumFacing facing) {
        switch (facing) {
            case SOUTH:
                return 180;
            case NORTH:
                return 0;
            case WEST:
                return -90;
            case EAST:
                return 90;
        }
        return 0;
    }
    public static float smoothRotation(float from, float to, float speed) {
        float f = MathHelper.wrapAngleTo180_float(to - from);

        if (f > speed) {
            f = speed;
        }

        if (f < -speed) {
            f = -speed;
        }

        return from + f;
    }
}
