package dev.bliss.api.util.player;

import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class PositionUtil
{
    private double x, y, width, height;

    private float scale;

    public PositionUtil(double x, double y, double width, double height, float scale) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scale = scale;
    }

    public double getX2() {
        return x + width;
    }
    public double getY2() {
        return y + height;
    }

    public boolean isInside(int mouseX, int mouseY) {
        return mouseX > getX() && mouseY > getY() && mouseX < getX() + width && mouseY < getY() + height;
    }
}
