package dev.bliss.api.util.player;

import net.minecraft.potion.Potion;

import static dev.bliss.BloomReborn.mc;
public class MoveUtil {
    public static boolean isOnGround() {
        return mc.thePlayer.onGround;
    }

    public static boolean isPlrMoving() {
        return mc.thePlayer.moveForward != 0 || mc.thePlayer.moveStrafing != 0;
    }

    public static float getPlrDir(float rotationYaw) {
        float yaw = mc.thePlayer.rotationYaw;
        float strafe = 45;
        if (mc.thePlayer.moveForward < 0) {
            strafe = -45;
            yaw += 180;
        }
        if (mc.thePlayer.moveStrafing > 0) {
            yaw -= strafe;
            if (mc.thePlayer.moveForward == 0) {
                yaw -= 45;
            }
        } else if (mc.thePlayer.moveStrafing < 0) {
            yaw += strafe;
            if (mc.thePlayer.moveForward == 0) {
                yaw += 45;
            }
        }
        return yaw;
    }

    public static double getBPS() {
        double bps = (Math.hypot(mc.thePlayer.posX - mc.thePlayer.prevPosX, mc.thePlayer.posZ - mc.thePlayer.prevPosZ) * mc.timer.timerSpeed) * 20;
        return Math.round(bps * 100.0) / 100.0;
    }
    public static double getMoveSpeed() {
        double baseSpeed = mc.thePlayer.capabilities.getWalkSpeed() * 2.873;
        if (mc.thePlayer.isPotionActive(Potion.moveSlowdown)) {
            baseSpeed /= 1.0 + 0.2 * (mc.thePlayer.getActivePotionEffect(Potion.moveSlowdown).getAmplifier() + 1);
        }
        if (mc.thePlayer.isPotionActive(Potion.moveSpeed)) {
            baseSpeed *= 1.0 + 0.2 * (mc.thePlayer.getActivePotionEffect(Potion.moveSpeed).getAmplifier() + 1);
        }
        return baseSpeed;
    }
    public static void strafe() {
        if (isPlrMoving()) {
            double dir = Math.toRadians(getPlrDir(mc.thePlayer.rotationYaw));
            mc.thePlayer.motionZ = Math.cos(dir) * getMoveSpeed();
            mc.thePlayer.motionX = -Math.sin(dir) * getMoveSpeed();
        }
    }
    public static void strafe(double speed) {
        if (isPlrMoving()) {
            double dir = Math.toRadians(getPlrDir(mc.thePlayer.prevRotationYaw));
            mc.thePlayer.motionZ = Math.cos(dir) * speed;
            mc.thePlayer.motionX = -Math.sin(dir) * speed;
        }
    }
    public static void jump() {
        mc.thePlayer.jump();
    }
    public static void jump(double height) {
        mc.thePlayer.motionY = height;
    }
}
