package dev.bliss.api.util.math;

import java.math.BigDecimal;
import java.math.MathContext;

import static net.optifine.CustomColors.random;

public class MathUtil {
    public double lerp(final double a, final  double b, final double c) {
        return a+c*(b-a);
    }

    public float lerp(final float a, final  float b, final float c) {
        return a+c*(b-a);
    }
    public static float randomFloat(float max, float min) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double roundToDecimalPlace(double value, double inc) {
        final double halfOfInc = inc / 2.0D;
        final double floored = StrictMath.floor(value / inc) * inc;
        if (value >= floored + halfOfInc)
            return new BigDecimal(StrictMath.ceil(value / inc) * inc, MathContext.DECIMAL64).
                    stripTrailingZeros()
                    .doubleValue();
        else
            return new BigDecimal(floored, MathContext.DECIMAL64)
                    .stripTrailingZeros()
                    .doubleValue();
    }

}
