package dev.bliss.api.script;

import dev.bliss.BloomReborn;
import dev.bliss.api.file.FileManager;
import dev.bliss.api.util.client.Priority;
import dev.bliss.impl.module.Category;
import dev.bliss.impl.module.Module;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;

public class ScriptManager
{
    public ArrayList<Script> scripts;

    public ScriptManager() {
        this.scripts = new ArrayList<Script>();
    }

    public void onStart() {
        for (final File f : Objects.requireNonNull(FileManager.INSTANCE.scriptDir.listFiles())) {
            final String unExtendedName = f.getName().substring(0, f.getName().length() - 5);
            System.out.println(unExtendedName);
            final Module mod = new Module(unExtendedName, Category.SCRIPT, Priority.med);
            BloomReborn.INSTANCE.scriptManager.scripts.add(new Script(mod));
            BloomReborn.INSTANCE.moduleManager.getModules().add(mod);
        }
        this.loadScripts();
    }

    public void loadScripts() {
        for (final Script c : BloomReborn.INSTANCE.scriptManager.scripts) {
            c.putVars();
            c.callEvent("onLoad");
        }
    }

    public Script getScriptByName(final String str) {
        for (final Script s : this.scripts) {
            if (s.scriptName.equals(str)) {
                return s;
            }
        }
        return null;
    }
}
