package dev.bliss.api.script;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.Event;
import dev.bliss.api.event.EventTarget;
import dev.bliss.api.event.events.*;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;

public class ScriptEvent {

    @EventTarget
    public void onTick(final EventTick e) {
        final EntityPlayerSP pl = Minecraft.getMinecraft().thePlayer;
        for (final Script script : BloomReborn.INSTANCE.scriptManager.scripts) {
            script.engineManager.put("localPlayer", pl);
            script.engineManager.put("mc", Minecraft.getMinecraft());
        }
        this.callFunc("onTick", e);
    }

    @EventTarget
    public void onPre(final EventMotion e) {
        this.callFunc("onPre", e);
    }

    @EventTarget
    public void onPacketSend(final EventSendPacket e) {
        this.callFunc("onSend", e);
    }

    @EventTarget
    public void onPacketRecieve(final EventReceivePacket e) {
        this.callFunc("onGet", e);
    }

    @EventTarget
    public void onDraw(final Event2D e) {
        this.callFunc("onDraw", e);
    }

    public void callFunc(final String funcName, final Event event) {
        for (final Script script : BloomReborn.INSTANCE.scriptManager.scripts) {
            if (script.scriptModule.isToggled()) {
                script.callEvent(funcName, event);
            }
        }
    }

}
