package dev.bliss.api.script;

import dev.bliss.BloomReborn;
import dev.bliss.api.event.Event;
import dev.bliss.api.setting.impl.SettingBool;
import dev.bliss.api.setting.impl.SettingDouble;
import dev.bliss.api.setting.impl.SettingMode;
import dev.bliss.impl.module.Module;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class Script {
    public Invocable invocable;
    public ScriptEngineManager engineManager;
    public ScriptEngine scriptEngine;
    public String scriptName;
    public File scriptFile;
    public Module scriptModule;

    public Script(final Module m) {
        scriptModule = m;
        scriptName = m.getName();
        scriptFile = new File(BloomReborn.INSTANCE.files.scriptDir, m.getName() + ".java");
        engineManager = new ScriptEngineManager();
        scriptEngine = engineManager.getEngineByExtension("java");
        invocable = (Invocable) scriptEngine;
    }

    public void callEvent(final String funcName) {
        try {
            FileReader reader = new FileReader(scriptFile);
            scriptEngine.eval(reader);
            reader.close();
            invocable.invokeFunction(funcName);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void callEvent(final String funcName, final Event e) {
        try {
            FileReader reader = new FileReader(scriptFile);
            scriptEngine.eval(reader);
            reader.close();
            invocable.invokeFunction(funcName, e);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void putVars() {
        scriptEngine.put("scriptManager", BloomReborn.INSTANCE.scriptManager);
        scriptEngine.put("module", scriptModule);
        scriptEngine.put("script", this);
    }

    public void declareSetting(final String mode, final Object... args) {
        switch (mode) {
            case "double":
                scriptModule.addSettings(new SettingDouble((String) args[0], (double) args[1], (double) args[2], (double) args[3], (double) args[4]));
                break;
            case "boolean":
                scriptModule.addSettings(new SettingBool((String) args[0], (boolean) args[1]));
                break;
            case "mode":
                List<String> strs = new ArrayList<>();
                for (int a = 2; a < args.length; ++a) {
                    strs.add((String) args[a]);
                }
                String[] strings = strs.toArray(new String[0]);
                scriptModule.addSettings(new SettingMode((String) args[0], (String) args[1], strings));
                break;
        }
    }
}

