package dev.bliss.api.file;

import dev.bliss.BloomReborn;
import dev.bliss.impl.module.Module;
import lombok.Getter;
import net.minecraft.client.Minecraft;

import java.io.*;
import java.util.ArrayList;

@Getter
public class FileManager {

    public static FileManager INSTANCE = new FileManager();

    public java.io.File dir = new java.io.File(Minecraft.getMinecraft().mcDataDir, "Bliss Reborn");
    public java.io.File dataDr;
    public java.io.File scriptDir = new java.io.File(dir, "Scripts");
    public java.io.File configDir = new java.io.File(dir, "Configs");


    public void reg() {

        loadKeys();
        makeDirs();

    }

    public void makeDirs() {
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!scriptDir.exists()) {
            scriptDir.mkdir();
        }
        if (!configDir.exists()) {
            configDir.mkdir();
        }
    }

    public void saveKeys() {
        this.dataDr = new java.io.File(this.dir, "keys.json");
        final ArrayList<String> toSave = new ArrayList<String>();
        for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
            toSave.add(m.getName() + ">" + m.getKey());
        }
        try {
            final PrintWriter pw = new PrintWriter(this.dataDr);
            for (final String str : toSave) {
                pw.println(str);
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void loadKeys() {
        this.dataDr = new java.io.File(this.dir, "keys.json");
        final ArrayList<String> lines = new ArrayList<String>();
        try {
            final BufferedReader reader = new BufferedReader(new FileReader(this.dataDr));
            for (String line = reader.readLine(); line != null; line = reader.readLine()) {
                lines.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (final String s : lines) {
                final String[] args = s.split(">");
                for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                    if (m.getName().equalsIgnoreCase(args[0])) {
                        m.setKey(Integer.parseInt(args[1]));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

}
