package dev.bliss.api.event.events;

import dev.bliss.api.event.Event;
import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class EventPreMotionUpdate extends Event {
    private float yaw, pitch;
    private boolean ground;
    public double x, y, z;
    float lastYaw;
    float lastPitch;

    public EventPreMotionUpdate(final float yaw, final float pitch, final float lastYaw, final float lastPitch, final boolean ground, final double x, final double y, final double z) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.ground = ground;
        this.x = x;
        this.y = y;
        this.z = z;
        this.lastYaw = lastYaw;
        this.lastPitch = lastPitch;
    }

    public boolean onGround() {
        return ground;
    }
}
