package dev.bliss.api.discord;

import dev.bliss.BloomReborn;
import dev.bliss.api.util.server.ServerUtil;
import net.arikia.dev.drpc.DiscordEventHandlers;
import net.arikia.dev.drpc.DiscordRPC;
import net.arikia.dev.drpc.DiscordRichPresence;
import net.arikia.dev.drpc.DiscordUser;
import net.arikia.dev.drpc.callbacks.ReadyCallback;
import net.minecraft.client.multiplayer.ServerData;

import static dev.bliss.BloomReborn.mc;

public class DiscordRP {

    private boolean running = true;
    private long created = 0;

    public void start() {

        this.created = System.currentTimeMillis();

        String b;
        String text = "Bliss Reborn " + BloomReborn.INSTANCE.getVersion();
        if (BloomReborn.INSTANCE.isAlpha()) b = "large_alpha";
        else b = "large_pub";

        DiscordEventHandlers handlers = new DiscordEventHandlers.Builder().setReadyEventHandler(new ReadyCallback() {
            @Override
            public void apply(DiscordUser user) {
                BloomReborn.INSTANCE.getLogger().info("Discord connected successfully: " + user.username + " (" + user.userId + ")");

                updateRPC(b, text, "", "", "Launching Bliss Client...", "");
            }
        }).build();

        DiscordRPC.discordInitialize("1221950024120795136", handlers, true);

        new Thread("DiscordRP Thread") {
            @Override
            public void run() {
                while(running) {
                    try {
                        ServerData server = mc.getCurrentServerData();
                        if (server != null) {
                            updateRPC(b, text, "mc", "Multiplayer Server", "Playing on " + server.serverIP, "");
                        } else if (ServerUtil.isOnHypixel()) {
                            updateRPC(b, text, "mc", "Hypixel.net", "Playing on Hypixel", "stomping on watchdog");
                        } else if (mc.isSingleplayer()) {
                            updateRPC(b, text, "mc", "Singleplayer World", "Playing in Singleplayer", "Loner Mode L");
                        } else {
                            updateRPC(b, text, "", "", "Main Menu", "Idle...");
                        }
                        Thread.sleep(5000); // delay so it doesnt tank fps
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    } catch (IllegalStateException e) {
                        e.printStackTrace();
                        break;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public void shutdown() {
        running = false;
        DiscordRPC.discordShutdown();
    }

    public void updateRPC(String bigImg, String bigImgText, String smallImg, String smallImgText, String details, String secondLine) {
        DiscordRichPresence.Builder b = new DiscordRichPresence.Builder(secondLine);
        b.setBigImage(bigImg, bigImgText);
        b.setSmallImage(smallImg, smallImgText);
        b.setDetails(details);
        b.setStartTimestamps(created);

        DiscordRPC.discordUpdatePresence(b.build());
    }

}
