package dev.bliss.api.config;

import dev.bliss.BloomReborn;
import dev.bliss.api.file.FileManager;
import dev.bliss.api.setting.ModuleCategory;
import dev.bliss.api.setting.Setting;
import dev.bliss.api.setting.impl.SettingBool;
import dev.bliss.api.setting.impl.SettingDouble;
import dev.bliss.api.setting.impl.SettingMode;
import dev.bliss.api.setting.impl.SettingString;
import dev.bliss.impl.module.Module;
import lombok.Getter;


import java.io.*;
import java.io.File;
import java.util.ArrayList;

@Getter
public class Config
{
    private File dir;
    private File dataFile;

    public void save(final String name) {

        this.dir = new File(String.valueOf(FileManager.INSTANCE.getConfigDir()));
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        this.dataFile = new File(this.dir, name + ".bloom");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Config file already exists!");
        }
        final ArrayList<String> toSave = new ArrayList<String>();
        for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
            toSave.add("Module:" + m.getName() + ":" + m.isToggled() + ":" + m.getKey() + ":" + '\u0001');
            for (final Setting s : m.settings) {
                if (s instanceof SettingDouble) {
                    final SettingDouble set = (SettingDouble)s;
                    toSave.add("SettingNumber:" + m.getName() + ":" + set.name + ":" + set.getValue());
                }
                else if (s instanceof SettingBool) {
                    final SettingBool set2 = (SettingBool)s;
                    toSave.add("SettingBool:" + m.getName() + ":" + set2.name + ":" + set2.enabled);
                }
                else if (s instanceof SettingMode) {
                    final SettingMode set3 = (SettingMode)s;
                    toSave.add("SettingMode:" + m.getName() + ":" + set3.name + ":" + set3.getMode());
                }
                else if (s instanceof SettingString) {
                    final SettingString set4 = (SettingString)s;
                    toSave.add("SettingString:" + m.getName() + ":" + set4.name + ":" + set4.getText());
                }
                else {
                    if (!(s instanceof ModuleCategory)) {
                        continue;
                    }
                    final ModuleCategory category = (ModuleCategory)s;
                    for (final Setting set5 : category.settingsOnCat) {
                        if (set5 instanceof SettingDouble) {
                            final SettingDouble dset = (SettingDouble)set5;
                            toSave.add("CategorySettingNumber:" + m.getName() + ":" + category.name + ":" + set5.name + ":" + dset.getValue());
                        }
                        else if (set5 instanceof SettingBool) {
                            final SettingBool bset = (SettingBool)set5;
                            toSave.add("CategorySettingBool:" + m.getName() + ":" + category.name + ":" + set5.name + ":" + bset.enabled);
                        }
                        else if (set5 instanceof SettingMode) {
                            final SettingMode mset = (SettingMode)set5;
                            toSave.add("CategorySettingMode:" + m.getName() + ":" + category.name + ":" + set5.name + ":" + mset.getMode());
                        }
                        else {
                            if (!(set5 instanceof SettingString)) {
                                continue;
                            }
                            final SettingString mset2 = (SettingString)set5;
                            toSave.add("CategorySettingString:" + m.getName() + ":" + category.name + ":" + set5.name + ":" + mset2.getText());
                        }
                    }
                }
            }
        }
        try {
            final PrintWriter pw = new PrintWriter(this.dataFile);
            for (final String str : toSave) {
                pw.println(str);
            }
            pw.close();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    public void delete(final String name) {
        this.dir = new java.io.File(String.valueOf(FileManager.INSTANCE.configDir));
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        this.dataFile = new java.io.File(this.dir, name + ".bloom");
        try {
            this.dataFile.delete();
        }
        catch (Exception ex) {}
    }

    public void load(final String name) {
        this.dir = new java.io.File(String.valueOf(FileManager.INSTANCE.configDir));
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        this.dataFile = new File(this.dir, name + ".bloom");
        final ArrayList<String> lines = new ArrayList<String>();
        try {
            final BufferedReader reader = new BufferedReader(new FileReader(this.dataFile));
            for (String line = reader.readLine(); line != null; line = reader.readLine()) {
                lines.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (final String s : lines) {
                final String[] args = s.split(":");
                if (s.toLowerCase().startsWith("module:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            final boolean shouldEnable = Boolean.parseBoolean(args[2]);
                            if (shouldEnable && !m.isToggled()) {
                                m.setToggled(true);
                            }
                            if (args.length > 4) {}
                        }
                    }
                }
                if (s.toLowerCase().startsWith("settingnumber:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof SettingDouble)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                final SettingDouble setting2 = (SettingDouble)setting;
                                setting2.setValue(Double.parseDouble(args[3]));
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("settingbool:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof SettingBool)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                final SettingBool setting3 = (SettingBool)setting;
                                setting3.setEnabled(Boolean.parseBoolean(args[3]));
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("settingmode:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof SettingMode)) {
                                    continue;
                                }
                                for (final String str : ((SettingMode)setting).modes) {
                                    if (setting.name.equalsIgnoreCase(args[2]) && args[3].equalsIgnoreCase(str)) {
                                        final SettingMode setting4 = (SettingMode)setting;
                                        setting4.setSelected(args[3]);
                                    }
                                }
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("settingstring:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof SettingString)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                final SettingString setting5 = (SettingString)setting;
                                setting5.setText(args[3]);
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("categorysettingnumber:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof ModuleCategory)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                for (final Setting setting6 : ((ModuleCategory)setting).settingsOnCat) {
                                    if (setting6.name.equalsIgnoreCase(args[3])) {
                                        final SettingDouble setting7 = (SettingDouble)setting6;
                                        setting7.setValue(Double.parseDouble(args[4]));
                                    }
                                }
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("categorysettingbool:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof ModuleCategory)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                try {
                                    for (final Setting setting6 : ((ModuleCategory)setting).settingsOnCat) {
                                        try {
                                            if (!setting6.name.equalsIgnoreCase(args[3])) {
                                                continue;
                                            }
                                            final SettingBool setting8 = (SettingBool)setting6;
                                            setting8.setEnabled(Boolean.parseBoolean(args[4]));
                                        }
                                        catch (Exception e2) {
                                            System.out.println("A: " + setting6.name + " B: " + setting.name + " C: " + m.getName());
                                        }
                                    }
                                }
                                catch (Exception e3) {
                                    System.out.println(setting.name);
                                }
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("categorysettingmode:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof ModuleCategory)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                for (final Setting setting6 : ((ModuleCategory)setting).settingsOnCat) {
                                    if (!(setting6 instanceof SettingMode)) {
                                        continue;
                                    }
                                    for (final String str2 : ((SettingMode)setting6).modes) {
                                        if (setting6.name.equalsIgnoreCase(args[3]) && args[4].equalsIgnoreCase(str2)) {
                                            final SettingMode setting9 = (SettingMode)setting6;
                                            setting9.setSelected(args[4]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (s.toLowerCase().startsWith("categorysettingstring:")) {
                    for (final Module m : BloomReborn.INSTANCE.moduleManager.getModules()) {
                        if (m.getName().equalsIgnoreCase(args[1])) {
                            for (final Setting setting : m.settings) {
                                if (!(setting instanceof ModuleCategory)) {
                                    continue;
                                }
                                if (!setting.name.equalsIgnoreCase(args[2])) {
                                    continue;
                                }
                                for (final Setting setting6 : ((ModuleCategory)setting).settingsOnCat) {
                                    if (setting6.name.equalsIgnoreCase(args[3])) {
                                        final SettingString setting10 = (SettingString)setting6;
                                        setting10.setText(args[4]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

