package dev.bliss.api.backendapi;

import com.mongodb.client.MongoDatabase;

public class ListenerApi {
    private MongoDatabase database;

    public ListenerApi(MongoDatabase database) {
        this.database = database;
    }

    public void onChatMessageFromUser(String message) {
        System.out.println("Chat message: " + message);
    }

    public void onDisconnectFromClient() {
        System.out.println("Disconnected from the server");
    }

    public void onConnectToClient() {
        System.out.println("Connected to the server");
    }

    public void onJoinToClient(String username) {
        System.out.println("User joined: " + username);
    }

    public void onLeaveFromClient(String username) {
        System.out.println("User left: " + username);
    }
}


