package dev.bliss;


import dev.bliss.api.discord.DiscordRP;
import dev.bliss.api.event.EventManager;
import dev.bliss.api.event.EventTarget;
import dev.bliss.api.event.events.*;
import dev.bliss.api.config.Config;
import dev.bliss.api.file.FileManager;
import dev.bliss.api.script.ScriptManager;
import dev.bliss.api.util.client.ClientUtil;
import dev.bliss.api.util.client.ReleaseType;
import dev.bliss.api.util.server.PingUtil;
import dev.bliss.api.via.viamcp.ViaMCP;
import dev.bliss.impl.command.CommandManager;
import dev.bliss.impl.module.ModuleManager;
import dev.bliss.impl.module.impl.visual.ClickGuiMod;
import lombok.Getter;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.Display;

import java.awt.*;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Getter
public class BloomReborn {

    public static BloomReborn INSTANCE = new BloomReborn();

    private final ReleaseType release = ReleaseType.DEV;
    @Getter
    private static String
            name = "Bliss",
            ver = "1.0.0",
            build = "@BUILD@";

    public static Minecraft mc = Minecraft.getMinecraft();
    private static final Logger logger = LogManager.getLogger(name);
    public ResourceLocation i;
    public FileManager files;
    public DiscordRP discordRP;
    public ClickGuiMod clickGui;
    public CommandManager commandManager;
    public Config configManager;
    public ScriptManager scriptManager;
    public EventManager eventManager;
    public ModuleManager moduleManager;
    @Getter
    public PingUtil pingUtil;
    public ClientUtil util;

    public Color mainColor;
    public Color secondaryColor;

    public void init() throws IOException {

        i = new ResourceLocation("bloom/icon.png"); // <-- this needs to be set but im retarded

        Display.setTitle(name + " " + getVersion());

        mainColor = new Color(66, 92, 196);
        secondaryColor = new Color(157, 144, 229);

        files = new FileManager();
        commandManager = new CommandManager();
        eventManager = new EventManager();
        moduleManager = new ModuleManager();
        scriptManager = new ScriptManager();
        configManager = new Config();
        clickGui = new ClickGuiMod();
        discordRP = new DiscordRP();
        pingUtil = new PingUtil();
        util = new ClientUtil();
        files.reg();

        try {
            if (build.toCharArray()[0] == '@') {
                build = new SimpleDateFormat("MMddyy").format(new Date());
            }
            ViaMCP.create();
            ViaMCP.INSTANCE.initAsyncSlider();
            ClientUtil.parseChangeLog();
            configManager.load("latest");
            eventManager.register(this);
            scriptManager.onStart();
            discordRP.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            files.saveKeys();
            configManager.save("latest");
            eventManager.unregister(this);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // <-- cool functions n stuff ig

    public String getVersion() {
        return ver + (release != ReleaseType.PUBLIC ? " | " + release.getName() : "");
    }

    public String getBuild() {
        return build + (release != ReleaseType.PUBLIC ? "-" + release.getName() : "");
    }

    public Logger getLogger() {
        return logger;
    }

    public boolean isAlpha() {
        return release == ReleaseType.ALPHA || release == ReleaseType.DEV;
    }

    public void addDebugMessage(String message) {
        message = "§f[" + "§9" + "Debug§f] " + message;
        Minecraft.getMinecraft().thePlayer.addChatMessage(new ChatComponentText(message));
    }

    public void addChatMessage(String message) {
        message = "§f[" + "§9" + "Bliss§f] " + message;
        Minecraft.getMinecraft().thePlayer.addChatMessage(new ChatComponentText(message));
    }

    // <-- event stuff ig

    public static void onEvent(final EventE e) {
        if (e instanceof EventChat) {
            BloomReborn.INSTANCE.commandManager.handleChat((EventChat)e);
        }
    }

    @EventTarget
    public void onKey(EventKey e) {
        this.moduleManager.getModules().stream().filter(module -> module.getKey() == e.getKey()).forEach(module -> module.toggle());
    }
}
