import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import rip.marie.logger.Logger;
import rip.marie.mutator.IMutator;
import rip.marie.mutator.data.integer.IntegerMutator;
import rip.marie.mutator.misc.AccessMutator;
import rip.marie.obfuscator.ZywcfuscatorBase;

import java.nio.file.Path;

public class Main {

    public static void main(String[] args) {

        Logger.debug = true;

        ZywcfuscatorBase.builder()
                .input(Path.of("in.jar"))
                .output(Path.of("out.jar"))
                .classReaderFlags(ClassReader.SKIP_DEBUG)
                .classWriterFlags(ClassWriter.COMPUTE_MAXS + ClassWriter.COMPUTE_FRAMES)
                .whitelistedPaths(new String[]{"org", "codes", "dev"})
                .blacklistedPaths(new String[0])
                .mutators(new IMutator[] {
                        new AccessMutator()
                })
                .build()
                .run();

    }

}
