package rip.marie.util.wrapper;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

/**
 * Wraps around the MethodNode
 *
 * @author Marie
 */
@Getter
@Setter
@AllArgsConstructor
public final class MethodWrapper {

    private ClassWrapper parent;
    private final MethodNode base;

    public InsnList getInstructions() {
        return base.instructions;
    }

}
