package rip.marie.util.asm;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

/**
 * Utils for bytecode (pushing things to stack for example)
 *
 * @author Marie
 */
public class BytecodeUtil implements Opcodes {

    public static AbstractInsnNode makeInteger(int number) {
        if (number >= -1 && number <= 5) {
            return new InsnNode(number + 3);
        } else if (number >= -128 && number <= 127) {
            return new IntInsnNode(BIPUSH, number);
        } else if (number >= -32768 && number <= 32767) {
            return new IntInsnNode(SIPUSH, number);
        } else {
            return new LdcInsnNode(number);
        }
    }

    public static boolean isInteger(AbstractInsnNode ain) {
        if (ain instanceof LdcInsnNode ldc) {
            return ldc.cst instanceof Integer;
        }

        int opcode = ain.getOpcode();

        return (opcode >= ICONST_M1 && opcode <= ICONST_5) || opcode == BIPUSH || opcode == SIPUSH;
    }

    public static int getInteger(AbstractInsnNode ain) {
        if (ain instanceof LdcInsnNode ldc && ldc.cst instanceof Integer) {
            return (int) ldc.cst;
        }

        if (ain instanceof IntInsnNode iin) {
            return iin.operand;
        }

        return switch (ain.getOpcode()) {
            case ICONST_M1 -> -1;
            case ICONST_0 -> 0;
            case ICONST_1 -> 1;
            case ICONST_2 -> 2;
            case ICONST_3 -> 3;
            case ICONST_4 -> 4;
            case ICONST_5 -> 5;
            default -> throw new IllegalStateException("Unexpected value: " + ain.getOpcode());
        };
    }

}
