package rip.marie.obfuscator;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import rip.marie.logger.LogLevel;
import rip.marie.logger.Logger;
import rip.marie.mutator.IMutator;
import rip.marie.util.FileUtil;
import rip.marie.util.wrapper.BinaryFileWrapper;
import rip.marie.util.wrapper.ClassWrapper;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@Builder
public final class ZywcfuscatorBase {
    private final ArrayList<BinaryFileWrapper> binaryFiles = new ArrayList<>();
    private final ArrayList<ClassWrapper> classes = new ArrayList<>();

    private final int classReaderFlags;
    private final int classWriterFlags;

    private final String[] whitelistedPaths;
    private final String[] blacklistedPaths;

    private final Path input;
    private final Path output;

    private final IMutator[] mutators;

    /**
     * Runs all operations
     */
    public void run() {

        Logger.log(LogLevel.INFO, "Loading jar...");

        FileUtil.loadJar(this);

        Logger.log(LogLevel.INFO, "Done loading jar!");

        for (IMutator mutator : mutators) {

            Logger.log(LogLevel.INFO, "Running ", mutator.getClass().getName(), "...");

            classes.forEach(ClassWrapper::pre);

            mutator.run(this);

            classes.forEach(ClassWrapper::post);

            Logger.log(LogLevel.INFO, "Done!");

        }

        Logger.log(LogLevel.INFO, "Writing jar...");

        FileUtil.saveJar(this);

        Logger.log(LogLevel.INFO, "Done writing jar!");

    }

    /**
     * @return Classes that are whitelisted, which means that the user allowed us to modify them
     */
    public List<ClassWrapper> getWhitelistedClasses() {
        return classes.stream().filter(c -> c.isModifiable(this)).toList();
    }
}
