package rip.marie.mutator.misc;

import org.objectweb.asm.tree.LineNumberNode;
import rip.marie.mutator.IMutator;
import rip.marie.obfuscator.ZywcfuscatorBase;

import java.util.Collections;

public class RemoveInfoMutator implements IMutator {

    @Override
    public void run(ZywcfuscatorBase base) {

        base.getWhitelistedClasses().forEach(classWrapper -> {

            classWrapper.getBase().sourceDebug = null;
            classWrapper.getBase().sourceFile = null;

            classWrapper.getBase().signature = null;

            classWrapper.getBase().innerClasses.clear();

            classWrapper.getFields().forEach(fieldWrapper -> {
                fieldWrapper.getBase().signature = null;
            });

            classWrapper.getMethods().forEach(methodWrapper -> {
                methodWrapper.getBase().signature = null;

                methodWrapper.getBase().localVariables = null;

                methodWrapper.getBase().instructions.resetLabels();

                methodWrapper.getInstructions().forEach(ain -> {
                    if (ain instanceof LineNumberNode)
                        methodWrapper.getInstructions().remove(ain);
                });
            });

            Collections.shuffle(classWrapper.getFields());
            Collections.shuffle(classWrapper.getMethods());

        });

    }

}
