package rip.marie.mutator.misc;

import rip.marie.mutator.IMutator;
import rip.marie.obfuscator.ZywcfuscatorBase;

import java.util.EnumMap;

import static org.objectweb.asm.Opcodes.*;

public class AccessMutator implements IMutator {

    @Override
    public void run(ZywcfuscatorBase base) {

        base.getWhitelistedClasses().forEach(classWrapper -> {
            int classAcc = classWrapper.getBase().access;

            if ((classAcc & ACC_SYNTHETIC) == 0) {
                classAcc |= ACC_SYNTHETIC;
            }

            if ((classAcc & ACC_MODULE) == 0) {
                classAcc |= ACC_MODULE;
            }

            if ((classAcc & ACC_DEPRECATED) == 0) {
                classAcc |= ACC_DEPRECATED;
            }

            if ((classAcc & ACC_STRICT) == 0) {
                classAcc |= ACC_STRICT;
            }

            if ((classAcc & ACC_RECORD) == 0) {
                classAcc |= ACC_RECORD;
            }

            classWrapper.getBase().access = classAcc;

            classWrapper.getFields().forEach(fieldWrapper -> {
                int fieldAcc = fieldWrapper.getBase().access;

                if ((fieldAcc & ACC_SYNTHETIC) == 0) {
                    fieldAcc |= ACC_SYNTHETIC;
                }

                if ((fieldAcc & ACC_DEPRECATED) == 0) {
                    fieldAcc |= ACC_DEPRECATED;
                }

                if ((fieldAcc & ACC_ENUM) == 0) {
                    fieldAcc |= ACC_ENUM;
                }

                fieldWrapper.getBase().access = fieldAcc;
            });

            classWrapper.getMethods().forEach(methodWrapper -> {
                if (methodWrapper.getBase().name.contains("<")) return;

                int methodAcc = methodWrapper.getBase().access;

                if ((methodAcc & ACC_SYNTHETIC) == 0) {
                    methodAcc |= ACC_SYNTHETIC;
                }

                if ((methodAcc & ACC_DEPRECATED) == 0) {
                    methodAcc |= ACC_DEPRECATED;
                }

                if ((methodAcc & ACC_BRIDGE) == 0) {
                    methodAcc |= ACC_BRIDGE;
                }

                if ((methodAcc & ACC_STRICT) == 0) {
                    methodAcc |= ACC_STRICT;
                }

                methodWrapper.getBase().access = methodAcc;
            });

        });

    }

}
