package rip.marie.mutator.flow;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.*;
import rip.marie.deadCodeEngine.LocalVariableObject;
import rip.marie.deadCodeEngine.LocalVariableObjectType;
import rip.marie.mutator.IMutator;
import rip.marie.obfuscator.ZywcfuscatorBase;
import rip.marie.util.asm.BytecodeUtil;
import rip.marie.util.wrapper.InsnListWrapper;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/**
 * Almost the same as the other one, just that it works with all types of jumps
 *
 * @author Marie
 */
public class SwitchJumpProxyMutator implements IMutator {

    @Override
    public void run(ZywcfuscatorBase base) {

        base.getWhitelistedClasses().forEach(classWrapper -> {

            classWrapper.getMethods().forEach(methodWrapper -> {

                HashMap<Integer /* switch case */, LabelNode /* switch label */> cases = new HashMap<>();
                LabelNode switchBegin = new LabelNode();
                LabelNode dflt = new LabelNode();
                int var = methodWrapper.getBase().maxLocals++;

                methodWrapper.getInstructions().forEach(instruction -> {
                    if (instruction instanceof JumpInsnNode jump) {

                        int key = RANDOM.nextInt();
                        while (cases.containsKey(key)) {
                            key = RANDOM.nextInt();
                        }

                        cases.put(key, jump.label);
                        jump.label = switchBegin;

                        InsnListWrapper list = new InsnListWrapper();
                        list.add(BytecodeUtil.makeInteger(key));
                        list.add(new VarInsnNode(Opcodes.ISTORE, var));

                        methodWrapper.getInstructions().insertBefore(instruction, list);

                    }
                });

                if (cases.isEmpty()) {
                    return;
                }

                int args = Type.getArgumentTypes(methodWrapper.getBase().desc).length;
                InsnListWrapper methodInit = new InsnListWrapper();
                ArrayList<LocalVariableObject> lvos = new ArrayList<>();
                methodWrapper.getInstructions().forEach(ain -> {

                    if (ain instanceof VarInsnNode vin) {
                        if (!Modifier.isStatic(methodWrapper.getBase().access) && vin.var == 0) return;
                        if (lvos.stream().anyMatch(lvo -> lvo.idx() == vin.var)) return;
                        if (vin.var <= args) return;

                        switch (vin.getOpcode()) {

                            case Opcodes.ISTORE, Opcodes.ILOAD -> lvos.add(new LocalVariableObject(vin.var, LocalVariableObjectType.INT));
                            case Opcodes.LSTORE, Opcodes.LLOAD -> lvos.add(new LocalVariableObject(vin.var, LocalVariableObjectType.LONG));
                            case Opcodes.DSTORE, Opcodes.DLOAD -> lvos.add(new LocalVariableObject(vin.var, LocalVariableObjectType.DOUBLE));
                            case Opcodes.FSTORE, Opcodes.FLOAD -> lvos.add(new LocalVariableObject(vin.var, LocalVariableObjectType.FLOAT));
                            case Opcodes.ASTORE, Opcodes.ALOAD -> lvos.add(new LocalVariableObject(vin.var, LocalVariableObjectType.OBJECT));
                            default -> throw new IllegalStateException("Wtf");

                        }

                    }

                });
                for (LocalVariableObject lvo : lvos) {
                    switch (lvo.type()) {

                        case INT -> {
                            methodInit.add(BytecodeUtil.makeInteger(RANDOM.nextInt()));
                            methodInit.add(new VarInsnNode(Opcodes.ISTORE, lvo.idx()));
                        }

                        case LONG -> {
                            if (RANDOM.nextBoolean()) {
                                methodInit.add(BytecodeUtil.makeInteger(RANDOM.nextInt()));
                                methodInit.add2(Opcodes.I2L);
                                methodInit.add(new VarInsnNode(Opcodes.LSTORE, lvo.idx()));
                            } else {
                                methodInit.add(new LdcInsnNode(RANDOM.nextLong()));
                                methodInit.add(new VarInsnNode(Opcodes.LSTORE, lvo.idx()));
                            }
                        }

                        case DOUBLE -> {
                            methodInit.add(new LdcInsnNode(RANDOM.nextGaussian() * Math.random()));
                            methodInit.add(new VarInsnNode(Opcodes.DSTORE, lvo.idx()));
                        }

                        case FLOAT -> {
                            methodInit.add(new LdcInsnNode(RANDOM.nextFloat() * RANDOM.nextFloat()));
                            methodInit.add(new VarInsnNode(Opcodes.FSTORE, lvo.idx()));
                        }

                        case OBJECT -> {
                            methodInit.add2(Opcodes.ACONST_NULL);
                            methodInit.add(new VarInsnNode(Opcodes.ASTORE, lvo.idx()));
                        }

                    }
                }
                methodWrapper.getInstructions().insertBefore(methodWrapper.getInstructions().getFirst(), methodInit);

                int[] sortedKeys = cases.keySet().stream().sorted().mapToInt(i -> i).toArray();
                LabelNode[] sortedLabels = Arrays.stream(sortedKeys)
                        .mapToObj(cases::get)
                        .toArray(LabelNode[]::new);

                InsnListWrapper list = new InsnListWrapper();
                list.add(switchBegin);
                list.add(new VarInsnNode(Opcodes.ILOAD, var));
                list.add(new LookupSwitchInsnNode(
                        dflt,
                        sortedKeys,
                        sortedLabels
                ));
                list.add(dflt);
                list.add2(
                        Opcodes.ACONST_NULL,
                        Opcodes.ATHROW
                );

                methodWrapper.getInstructions().add(list);

            });

        });

    }

}
