package rip.marie.mutator.flow;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import rip.marie.mutator.IMutator;
import rip.marie.obfuscator.ZywcfuscatorBase;
import rip.marie.util.asm.BytecodeUtil;
import rip.marie.util.wrapper.InsnListWrapper;

/**
 * More like a GOTO to LookupSwitchInsnNode converter
 *
 * @author Marie
 */
public class SwitchJumpMutator implements IMutator {

    @Override
    public void run(ZywcfuscatorBase base) {

        base.getWhitelistedClasses().forEach(classWrapper -> {

            classWrapper.getMethods().forEach(methodWrapper -> {

                methodWrapper.getInstructions().forEach(instruction -> {

                    if (instruction instanceof JumpInsnNode jump && instruction.getOpcode() == Opcodes.GOTO) {

                        int key = RANDOM.nextInt();

                        LabelNode fail = new LabelNode();

                        LookupSwitchInsnNode switchNode = new LookupSwitchInsnNode(fail, new int[] {key}, new LabelNode[] {jump.label});

                        InsnListWrapper list = new InsnListWrapper();

                        list.add(BytecodeUtil.makeInteger(key));
                        list.add(switchNode);
                        list.add(fail);
                        list.add2(
                                Opcodes.ACONST_NULL,
                                Opcodes.ATHROW
                        );

                        methodWrapper.getInstructions().insert(instruction, list);
                        methodWrapper.getInstructions().remove(instruction);

                    }

                });

            });

        });

    }

}
