package rip.marie.mutator.flow;

import rip.marie.mutator.IMutator;
import rip.marie.deadCodeEngine.DeadCodeGenerator;
import rip.marie.obfuscator.ZywcfuscatorBase;

public class DeadCodeMutator implements IMutator {

    @Override
    public void run(ZywcfuscatorBase base) {

        base.getWhitelistedClasses().forEach(classWrapper -> {

            classWrapper.getMethods().forEach(methodWrapper -> {

                final DeadCodeGenerator dcg = new DeadCodeGenerator(methodWrapper);

                methodWrapper.getInstructions().forEach(ain -> {

                    if (Math.random() < 0.8) return;

                    dcg.insertDeadCode(ain);

                });

            });

        });

    }

}
