package rip.marie.mutator.data.string.modifier.impl;

import org.objectweb.asm.tree.*;
import rip.marie.mutator.data.string.StringEncryptionData;
import rip.marie.mutator.data.string.modifier.CharModifier;
import rip.marie.mutator.data.string.modifier.CharModifierData;
import rip.marie.util.asm.BytecodeUtil;

import static org.objectweb.asm.Opcodes.*;

public class MethodSaltXorCharModifier extends CharModifier {
    private final boolean addBefore;
    private final boolean addAfter;
    private final int keyBefore;
    private final int keyAfter;

    public MethodSaltXorCharModifier() {
        this.addBefore = random.nextBoolean();
        this.addAfter = random.nextBoolean();
        this.keyBefore = random.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
        this.keyAfter = random.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    @Override
    public InsnList generate(MethodNode methodNode, CharModifierData data) {
        final InsnList instructions = new InsnList();
        instructions.add(new LabelNode());
        instructions.add(new VarInsnNode(ILOAD, data.currentCharacterIndex));

        if (addBefore) {
            boolean variable = random.nextBoolean();
            instructions.add(BytecodeUtil.makeInteger(keyBefore));
            if (variable) {
                int variableIndex = methodNode.maxLocals++;
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
        }

        instructions.add(new VarInsnNode(ILOAD, data.keyCallingIndex));
        instructions.add(new InsnNode(IXOR));

        if (addAfter) {
            boolean variable = random.nextBoolean();
            instructions.add(BytecodeUtil.makeInteger(keyAfter));
            if (variable) {
                int variableIndex = methodNode.maxLocals++;
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
        }

        instructions.add(new InsnNode(I2C));
        instructions.add(new VarInsnNode(ISTORE, data.currentCharacterIndex));
        return instructions;
    }

    @Override
    public char perform(StringEncryptionData data, int index, char character) {
        int result = character;

        if (addBefore) {
            result ^= keyBefore;
        }

        result ^= data.keyCalling;

        if (addAfter) {
            result ^= keyAfter;
        }

        return (char) (result);
    }
}