package rip.marie.mutator.data.string.modifier.impl;

import org.objectweb.asm.tree.*;
import rip.marie.mutator.data.string.StringEncryptionData;
import rip.marie.mutator.data.string.modifier.CharModifier;
import rip.marie.mutator.data.string.modifier.CharModifierData;
import rip.marie.util.asm.BytecodeUtil;

import static org.objectweb.asm.Opcodes.*;

public class IndexSwitchXorCharModifier extends CharModifier {
    private final int size;
    private final int[] key;

    public IndexSwitchXorCharModifier() {
        this.size = this.random.nextInt(8, 32 + 1);
        this.key = new int[size];
        for (int i = 0; i < size; i++) {
            this.key[i] = this.random.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
        }
    }

    @SuppressWarnings("SpellCheckingInspection")
    @Override
    public InsnList generate(MethodNode methodNode, CharModifierData data) {
        final InsnList instructions = new InsnList();

        LabelNode lblNext = data.lblNext;

        LabelNode lblDivisor = new LabelNode();
        instructions.add(lblDivisor);
        instructions.add(new VarInsnNode(ILOAD, data.loopIntegerIndex));
        instructions.add(BytecodeUtil.makeInteger(size));
        instructions.add(new InsnNode(IREM));

        // zelix klassmaster latest صِرَٰطَ ٱلَّذِينَ أَنْعَمْتَ عَلَيْهِمْ غَيْرِ ٱلْمَغْضُوبِ عَلَيْهِم ولا ٱلضَّآلِّينَ trial hack
        LabelNode[] lblCaseArr = new LabelNode[size];
        for (int i = 0; i < size; i++) {
            lblCaseArr[i] = new LabelNode();
        }

        instructions.add(new TableSwitchInsnNode(0, size - 1, lblNext, lblCaseArr));

        for (int i = 0; i < size; i++) {
            boolean variable = random.nextBoolean();
            int variableIndex = methodNode.maxLocals++;

            LabelNode lblCase = lblCaseArr[i];

            instructions.add(lblCase);
            instructions.add(new FrameNode(F_APPEND, 1, new Object[]{INTEGER}, 0, null));
            instructions.add(new VarInsnNode(ILOAD, data.currentCharacterIndex));
            instructions.add(BytecodeUtil.makeInteger(key[i]));
            if (variable) {
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
            instructions.add(new InsnNode(I2C));
            instructions.add(new VarInsnNode(ISTORE, data.currentCharacterIndex));

            LabelNode lblBreak = new LabelNode();
            instructions.add(lblBreak);
            instructions.add(new JumpInsnNode(GOTO, lblNext));
        }

        return instructions;
    }

    @Override
    public char perform(StringEncryptionData data, int index, char character) {
        int result = character ^ key[index % size];
        return (char) result;
    }
}