package rip.marie.mutator.data.string.modifier.impl;

import org.objectweb.asm.tree.*;
import rip.marie.mutator.data.string.StringEncryptionData;
import rip.marie.mutator.data.string.modifier.CharModifier;
import rip.marie.mutator.data.string.modifier.CharModifierData;
import rip.marie.util.asm.BytecodeUtil;

import static org.objectweb.asm.Opcodes.*;

public class ConstantXorCharModifier extends CharModifier {
    private final int key;

    private final boolean keySalt, keySaltType;
    private final boolean indexSalt, indexSaltType;

    public ConstantXorCharModifier() {
        this.key = random.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);

        this.keySalt = this.random.nextBoolean();
        this.keySaltType = this.random.nextBoolean();

        this.indexSalt = this.random.nextBoolean();
        this.indexSaltType = this.random.nextBoolean();
    }

    @Override
    public InsnList generate(MethodNode methodNode, CharModifierData data) {
        final InsnList instructions = new InsnList();
        instructions.add(new LabelNode());
        instructions.add(new VarInsnNode(ILOAD, data.currentCharacterIndex));

        if (indexSalt && !indexSaltType) {
            boolean variable = random.nextBoolean();
            instructions.add(new VarInsnNode(ILOAD, data.stringIndexIndex));
            if (variable) {
                int variableIndex = methodNode.maxLocals++;
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
        }

        if (keySalt && !keySaltType) {
            boolean variable = random.nextBoolean();
            instructions.add(new VarInsnNode(ILOAD, data.stringKeyIndex));
            if (variable) {
                int variableIndex = methodNode.maxLocals++;
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
        }

        instructions.add(BytecodeUtil.makeInteger(key));
        instructions.add(new InsnNode(IXOR));

        if (indexSalt && indexSaltType) {
            boolean variable = random.nextBoolean();
            instructions.add(new VarInsnNode(ILOAD, data.stringIndexIndex));
            if (variable) {
                int variableIndex = methodNode.maxLocals++;
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
        }

        if (keySalt && keySaltType) {
            boolean variable = random.nextBoolean();
            instructions.add(new VarInsnNode(ILOAD, data.stringKeyIndex));
            if (variable) {
                int variableIndex = methodNode.maxLocals++;
                instructions.add(new VarInsnNode(ISTORE, variableIndex));
                instructions.add(new VarInsnNode(ILOAD, variableIndex));
            }
            instructions.add(new InsnNode(IXOR));
        }

        instructions.add(new InsnNode(I2C));
        instructions.add(new VarInsnNode(ISTORE, data.currentCharacterIndex));
        return instructions;
    }

    @Override
    public char perform(StringEncryptionData data, int index, char character) {
        int result = character;

        if (indexSalt && !indexSaltType) {
            result ^= data.index;
        }

        if (keySalt && !keySaltType) {
            result ^= data.key;
        }

        result ^= key;

        if (indexSalt && indexSaltType) {
            result ^= data.index;
        }

        if (keySalt && keySaltType) {
            result ^= data.key;
        }

        return (char) result;
    }
}