package rip.marie.mutator.data.integer;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.VarInsnNode;
import rip.marie.mutator.IMutator;
import rip.marie.obfuscator.ZywcfuscatorBase;
import rip.marie.util.asm.BytecodeUtil;
import rip.marie.util.wrapper.InsnListWrapper;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * My plan is to make this as polymorphic as possible (soon)
 *
 * @author Marie
 */
public class IntegerMutator implements IMutator {

    @Override
    public void run(ZywcfuscatorBase base) {

        base.getWhitelistedClasses().forEach(classWrapper -> {

            classWrapper.getMethods().forEach(methodWrapper -> {

                HashMap<Integer /* variable number */, Integer /* value */> values = new HashMap<>();

                InsnListWrapper initList = new InsnListWrapper();

                for (int i = 0; i < RANDOM.nextInt(5) + 10; i++) {
                    int var = methodWrapper.getBase().maxLocals++;
                    int val = RANDOM.nextInt();

                    if (i == 0) {
                        initList.add(BytecodeUtil.makeInteger(val));
                    } else {
                        int xorVar = (int) values.keySet().toArray()[i - 1];
                        int xorVal = values.get(xorVar);

                        if (RANDOM.nextBoolean()) {
                            initList.add(new VarInsnNode(Opcodes.ILOAD, xorVar));
                            initList.add(BytecodeUtil.makeInteger(xorVal ^ val));
                        } else {
                            initList.add(BytecodeUtil.makeInteger(xorVal ^ val));
                            initList.add(new VarInsnNode(Opcodes.ILOAD, xorVar));
                        }

                        initList.add2(Opcodes.IXOR);

                    }

                    initList.add(new VarInsnNode(Opcodes.ISTORE, var));

                    values.put(var, val);

                }

                AtomicBoolean shouldAddInit = new AtomicBoolean();

                methodWrapper.getInstructions().forEach(instruction -> {

                    if (BytecodeUtil.isInteger(instruction)) {

                        InsnListWrapper insnList = new InsnListWrapper();

                        int originalVal = BytecodeUtil.getInteger(instruction);

                        int xorVar = (int) values.keySet().toArray()[RANDOM.nextInt(values.size())];
                        int xorVal = values.get(xorVar);

                        if (RANDOM.nextBoolean()) {
                            insnList.add(new VarInsnNode(Opcodes.ILOAD, xorVar));
                            insnList.add(BytecodeUtil.makeInteger(xorVal ^ originalVal));
                        } else {
                            insnList.add(BytecodeUtil.makeInteger(xorVal ^ originalVal));
                            insnList.add(new VarInsnNode(Opcodes.ILOAD, xorVar));
                        }

                        insnList.add2(Opcodes.IXOR);

                        methodWrapper.getInstructions().insert(instruction, insnList);
                        methodWrapper.getInstructions().remove(instruction);

                        shouldAddInit.set(true);

                    }

                });

                if (shouldAddInit.get()) {
                    methodWrapper.getInstructions().insertBefore(methodWrapper.getInstructions().getFirst(), initList);
                }

            });

        });

    }

}
