package rip.marie.logger;

import lombok.experimental.UtilityClass;

/**
 * Just a simple logger meant as a replacement for normal printing
 *
 * @author Marie
 */
@UtilityClass
public final class Logger {

    public static boolean debug = false;

    /**
     * Prints a log line to console with concatenated objects
     *
     * @param level The Log level which defines the prefix
     * @param o A list of objects to be logged
     */
    public static void log(final LogLevel level, final Object... o) {
        if (level == LogLevel.DEBUG && !debug) return;

        final StringBuilder sb = new StringBuilder();

        for (final Object obj : o) {
            sb.append(obj);
        }

        System.out.println(level.getPrefix() + sb);
    }

}
