package eventBus;

import org.volt.api.event.EventReceiver;
import org.volt.impl.event.EventBus;

public final class EventBusTest
{
    public static void main(String[] args)
    {
        new EventBusTest();
    }

    public EventBusTest()
    {
        final EventBus bus = new EventBus();

        bus.register(this);

        bus.call(new TestEvent(bus.toString())); // should fire

        bus.unregister(this);

        bus.call(new TestEvent(bus.toString())); // should NOT fire
    }

    @EventReceiver
    public void onData(final TestEvent event)
    {
        System.out.printf("Got data: %s%n", event.data);
    }
}
