package org.volt.impl.module;

import org.volt.api.module.*;
import org.volt.impl.client.Volt;

/**
 * Manages the parent modules states and registers it inside the eventbus
 * @author marie
 */
public final class ModuleStateHolder implements IModuleStateHolder
{
    /**
     * Current toggled state of the parent module
     */
    private boolean toggled = false;

    /**
     * Parent module
     */
    private final IModule parent;

    /**
     * Stores module info
     */
    private final ModuleInfo info;

    public ModuleStateHolder(final IModule parent)
    {
        this.parent = parent;

        ModuleInfo annotation = parent.getClass().getAnnotation(ModuleInfo.class);

        if (annotation != null)
        {
            this.info = annotation;
        }
        else
        {
            throw new IllegalArgumentException("No module info present!");
        }
    }

    @Override
    public boolean isToggled()
    {
        return toggled;
    }

    @Override
    public void toggle()
    {
        toggled = !toggled;

        if (toggled)
        {
            Volt.SINGLETON.getEventBus().register(parent);
        }
        else
        {
            Volt.SINGLETON.getEventBus().unregister(parent);
        }
    }

    @Override
    public ModuleInfo getModuleInfo()
    {
        return info;
    }
}
