package org.volt.impl.module;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import org.volt.api.module.IModule;
import org.volt.api.module.IModuleManager;
import org.volt.api.module.IModuleStateHolder;
import org.volt.impl.module.misc.TestModule;

/**
 * Manages all registered modules
 * @author marie
 */
public final class ModuleManager implements IModuleManager
{
    /**
     * Keeps all modules and their state holder instance
     */
    private final Object2ReferenceMap<IModule, IModuleStateHolder> moduleStateMap = new Object2ReferenceOpenHashMap<>();

    @Override
    public void initialize()
    {
        registerModule(new TestModule());
    }

    @Override
    public void registerModule(final IModule module)
    {
        moduleStateMap.put(module, new ModuleStateHolder(module));
    }

    @Override
    @SuppressWarnings("unchecked") // I made sure this won't matter
    public <T> T getModuleByClass(final Class<T> clazz)
    {
        return (T) moduleStateMap.keySet().stream().filter(m -> m.getClass() == clazz).findFirst().orElse(null);
    }

    @Override
    public IModuleStateHolder getModuleStateByClass(final Class<?> clazz)
    {
        final Object module = getModuleByClass(clazz);

        if (module == null) return null;

        return moduleStateMap.get(module);
    }
}
